<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: contact information
 * @subpackage Structs
 */
class ContactInformationType extends AbstractStructBase
{
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $Value;
    /**
     * The ContactType
     * Meta information extracted from the WSDL
     * - documentation: type code to identify different contact.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $ContactType;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The Begin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Begin;
    /**
     * Constructor method for ContactInformationType
     * @uses ContactInformationType::setValue()
     * @uses ContactInformationType::setContactType()
     * @uses ContactInformationType::setDescription()
     * @uses ContactInformationType::setBegin()
     * @param string $value
     * @param string $contactType
     * @param \KBO\StructType\DescriptionType[] $description
     * @param string $begin
     */
    public function __construct($value = null, $contactType = null, array $description = array(), $begin = null)
    {
        $this
            ->setValue($value)
            ->setContactType($contactType)
            ->setDescription($description)
            ->setBegin($begin);
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \KBO\StructType\ContactInformationType
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get ContactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param string $contactType
     * @return \KBO\StructType\ContactInformationType
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: string
        if (!is_null($contactType) && !is_string($contactType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactType, true), gettype($contactType)), __LINE__);
        }
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Get Description value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInformationTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$contactInformationTypeDescriptionItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($contactInformationTypeDescriptionItem) ? get_class($contactInformationTypeDescriptionItem) : sprintf('%s(%s)', gettype($contactInformationTypeDescriptionItem), var_export($contactInformationTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $description
     * @return \KBO\StructType\ContactInformationType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\ContactInformationType
     */
    public function addToDescription(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Begin value
     * @return string|null
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \KBO\StructType\ContactInformationType
     */
    public function setBegin($begin = null)
    {
        // validation for constraint: string
        if (!is_null($begin) && !is_string($begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($begin, true), gettype($begin)), __LINE__);
        }
        $this->Begin = $begin;
        return $this;
    }
}
