<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BranchType StructType
 * @subpackage Structs
 */
class BranchType extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [09]?[0-9]{9}
     * @var int
     */
    public $Id;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \KBO\StructType\StatusType
     */
    public $Status;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \KBO\StructType\AddressType
     */
    public $Address;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \KBO\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The Denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\DenominationType[]
     */
    public $Denomination;
    /**
     * Constructor method for BranchType
     * @uses BranchType::setId()
     * @uses BranchType::setStatus()
     * @uses BranchType::setAddress()
     * @uses BranchType::setValidityPeriod()
     * @uses BranchType::setDenomination()
     * @param int $id
     * @param \KBO\StructType\StatusType $status
     * @param \KBO\StructType\AddressType $address
     * @param \KBO\StructType\PeriodType $validityPeriod
     * @param \KBO\StructType\DenominationType[] $denomination
     */
    public function __construct($id = null, \KBO\StructType\StatusType $status = null, \KBO\StructType\AddressType $address = null, \KBO\StructType\PeriodType $validityPeriod = null, array $denomination = array())
    {
        $this
            ->setId($id)
            ->setStatus($status)
            ->setAddress($address)
            ->setValidityPeriod($validityPeriod)
            ->setDenomination($denomination);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \KBO\StructType\BranchType
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([09]?[0-9]{9})
        if (!is_null($id) && !preg_match('/[09]?[0-9]{9}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [09]?[0-9]{9}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return \KBO\StructType\StatusType
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \KBO\StructType\StatusType $status
     * @return \KBO\StructType\BranchType
     */
    public function setStatus(\KBO\StructType\StatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Address value
     * @return \KBO\StructType\AddressType
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \KBO\StructType\AddressType $address
     * @return \KBO\StructType\BranchType
     */
    public function setAddress(\KBO\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \KBO\StructType\PeriodType
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \KBO\StructType\PeriodType $validityPeriod
     * @return \KBO\StructType\BranchType
     */
    public function setValidityPeriod(\KBO\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get Denomination value
     * @return \KBO\StructType\DenominationType[]|null
     */
    public function getDenomination()
    {
        return $this->Denomination;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $branchTypeDenominationItem) {
            // validation for constraint: itemType
            if (!$branchTypeDenominationItem instanceof \KBO\StructType\DenominationType) {
                $invalidValues[] = is_object($branchTypeDenominationItem) ? get_class($branchTypeDenominationItem) : sprintf('%s(%s)', gettype($branchTypeDenominationItem), var_export($branchTypeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Denomination property can only contain items of type \KBO\StructType\DenominationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Denomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DenominationType[] $denomination
     * @return \KBO\StructType\BranchType
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        $this->Denomination = $denomination;
        return $this;
    }
    /**
     * Add item to Denomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DenominationType $item
     * @return \KBO\StructType\BranchType
     */
    public function addToDenomination(\KBO\StructType\DenominationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DenominationType) {
            throw new \InvalidArgumentException(sprintf('The Denomination property can only contain items of type \KBO\StructType\DenominationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Denomination[] = $item;
        return $this;
    }
}
