<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JuridicalFormType StructType
 * @subpackage Structs
 */
class JuridicalFormType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \KBO\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\PeriodType
     */
    public $ValidityPeriod;
    /**
     * The JuridicalFormCAC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\JuridicalFormCACType
     */
    public $JuridicalFormCAC;
    /**
     * Constructor method for JuridicalFormType
     * @uses JuridicalFormType::setCode()
     * @uses JuridicalFormType::setDescription()
     * @uses JuridicalFormType::setValidityPeriod()
     * @uses JuridicalFormType::setJuridicalFormCAC()
     * @param string $code
     * @param \KBO\StructType\DescriptionType[] $description
     * @param \KBO\StructType\PeriodType $validityPeriod
     * @param \KBO\StructType\JuridicalFormCACType $juridicalFormCAC
     */
    public function __construct($code = null, array $description = array(), \KBO\StructType\PeriodType $validityPeriod = null, \KBO\StructType\JuridicalFormCACType $juridicalFormCAC = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setValidityPeriod($validityPeriod)
            ->setJuridicalFormCAC($juridicalFormCAC);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \KBO\StructType\JuridicalFormType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $juridicalFormTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$juridicalFormTypeDescriptionItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($juridicalFormTypeDescriptionItem) ? get_class($juridicalFormTypeDescriptionItem) : sprintf('%s(%s)', gettype($juridicalFormTypeDescriptionItem), var_export($juridicalFormTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $description
     * @return \KBO\StructType\JuridicalFormType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\JuridicalFormType
     */
    public function addToDescription(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \KBO\StructType\PeriodType $validityPeriod
     * @return \KBO\StructType\JuridicalFormType
     */
    public function setValidityPeriod(\KBO\StructType\PeriodType $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get JuridicalFormCAC value
     * @return \KBO\StructType\JuridicalFormCACType|null
     */
    public function getJuridicalFormCAC()
    {
        return $this->JuridicalFormCAC;
    }
    /**
     * Set JuridicalFormCAC value
     * @param \KBO\StructType\JuridicalFormCACType $juridicalFormCAC
     * @return \KBO\StructType\JuridicalFormType
     */
    public function setJuridicalFormCAC(\KBO\StructType\JuridicalFormCACType $juridicalFormCAC = null)
    {
        $this->JuridicalFormCAC = $juridicalFormCAC;
        return $this;
    }
}
