<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://kbopub-acc.economie.fgov.be/kbopubws110000/services/wsKBOPub?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://kbopub-acc.economie.fgov.be/kbopubws110000/services/wsKBOPub?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \KBO\ClassMap::get(),
);
/**
 * Samples for Read ServiceType
 */
$read = new \KBO\ServiceType\Read($options);
$read->setSoapHeaderRequestContext($RequestContext);
/**
 * Sample call for ReadEnterprise operation/method
 */
if ($read->ReadEnterprise(new \KBO\StructType\ReadEnterpriseRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseByPhoneme operation/method
 */
if ($read->ReadEnterpriseByPhoneme(new \KBO\StructType\ReadEnterpriseByPhonemeRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByEnterpriseNumber operation/method
 */
if ($read->ReadEstablishmentByEnterpriseNumber(new \KBO\StructType\ReadEstablishmentByEnterpriseNumberRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByEstablishmentNumber operation/method
 */
if ($read->ReadEstablishmentByEstablishmentNumber(new \KBO\StructType\ReadEstablishmentByEstablishmentNumberRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseByPhysicalPersonNameExactMatch operation/method
 */
if ($read->ReadEnterpriseByPhysicalPersonNameExactMatch(new \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseLegalPersonByCompanyNameExactMatch
 * operation/method
 */
if ($read->ReadEnterpriseLegalPersonByCompanyNameExactMatch(new \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByNameExactMatch operation/method
 */
if ($read->ReadEstablishmentByNameExactMatch(new \KBO\StructType\ReadEstablishmentByNameExactMatchRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByPhoneme operation/method
 */
if ($read->ReadEstablishmentByPhoneme(new \KBO\StructType\ReadEstablishmentByPhonemeRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseOrEstablishmentByAddress operation/method
 */
if ($read->ReadEnterpriseOrEstablishmentByAddress(new \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadStreetName operation/method
 */
if ($read->ReadStreetName(new \KBO\StructType\ReadStreetNameRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseOrEstablishmentByActivity operation/method
 */
if ($read->ReadEnterpriseOrEstablishmentByActivity(new \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEnterpriseByAuthorization operation/method
 */
if ($read->ReadEnterpriseByAuthorization(new \KBO\StructType\ReadEnterpriseByAuthorizationRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadEstablishmentByAuthorization operation/method
 */
if ($read->ReadEstablishmentByAuthorization(new \KBO\StructType\ReadEstablishmentByAuthorizationRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
/**
 * Sample call for ReadCodeList operation/method
 */
if ($read->ReadCodeList(new \KBO\StructType\ReadCodeListRequestType()) !== false) {
    print_r($read->getResult());
} else {
    print_r($read->getLastError());
}
