<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterpriseType StructType
 * @subpackage Structs
 */
class EnterpriseType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [01]?[0-9]{9}
     * @var int
     */
    public $Number;
    /**
     * The JuridicalSituation
     * @var \KBO\StructType\JuridicalSituationType
     */
    public $JuridicalSituation;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Duration;
    /**
     * The TypeOfEnterprise
     * @var string
     */
    public $TypeOfEnterprise;
    /**
     * The JuridicalForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\JuridicalFormType
     */
    public $JuridicalForm;
    /**
     * The Capital
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\CapitalType
     */
    public $Capital;
    /**
     * The PrimaryDenomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\DescriptionType[]
     */
    public $PrimaryDenomination;
    /**
     * The Denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\DenominationType[]
     */
    public $Denomination;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \KBO\StructType\AddressType[]
     */
    public $Address;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ContactInformationType[]
     */
    public $ContactInformation;
    /**
     * The BusinessUnits
     * @var int
     */
    public $BusinessUnits;
    /**
     * The Branch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\BranchType[]
     */
    public $Branch;
    /**
     * The ProfessionalCompetence
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ProfessionalCompetenceType[]
     */
    public $ProfessionalCompetence;
    /**
     * The Qualification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\QualificationType[]
     */
    public $Qualification;
    /**
     * The Authorization
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\AuthorizationType[]
     */
    public $Authorization;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ActivityType[]
     */
    public $Activity;
    /**
     * The Function
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\FunctionType[]
     */
    public $Function;
    /**
     * The LinkedEnterprise
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\LinkedEnterpriseType[]
     */
    public $LinkedEnterprise;
    /**
     * The FinancialData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \KBO\StructType\FinancialDataType
     */
    public $FinancialData;
    /**
     * The Replacement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ReplacementType[]
     */
    public $Replacement;
    /**
     * The ExOfficioStrikingOff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ExOfficioStrikingOffType[]
     */
    public $ExOfficioStrikingOff;
    /**
     * Constructor method for EnterpriseType
     * @uses EnterpriseType::setNumber()
     * @uses EnterpriseType::setJuridicalSituation()
     * @uses EnterpriseType::setPeriod()
     * @uses EnterpriseType::setDuration()
     * @uses EnterpriseType::setTypeOfEnterprise()
     * @uses EnterpriseType::setJuridicalForm()
     * @uses EnterpriseType::setCapital()
     * @uses EnterpriseType::setPrimaryDenomination()
     * @uses EnterpriseType::setDenomination()
     * @uses EnterpriseType::setAddress()
     * @uses EnterpriseType::setContactInformation()
     * @uses EnterpriseType::setBusinessUnits()
     * @uses EnterpriseType::setBranch()
     * @uses EnterpriseType::setProfessionalCompetence()
     * @uses EnterpriseType::setQualification()
     * @uses EnterpriseType::setAuthorization()
     * @uses EnterpriseType::setActivity()
     * @uses EnterpriseType::setFunction()
     * @uses EnterpriseType::setLinkedEnterprise()
     * @uses EnterpriseType::setFinancialData()
     * @uses EnterpriseType::setReplacement()
     * @uses EnterpriseType::setExOfficioStrikingOff()
     * @param int $number
     * @param \KBO\StructType\JuridicalSituationType $juridicalSituation
     * @param \KBO\StructType\PeriodType $period
     * @param int $duration
     * @param string $typeOfEnterprise
     * @param \KBO\StructType\JuridicalFormType $juridicalForm
     * @param \KBO\StructType\CapitalType $capital
     * @param \KBO\StructType\DescriptionType[] $primaryDenomination
     * @param \KBO\StructType\DenominationType[] $denomination
     * @param \KBO\StructType\AddressType[] $address
     * @param \KBO\StructType\ContactInformationType[] $contactInformation
     * @param int $businessUnits
     * @param \KBO\StructType\BranchType[] $branch
     * @param \KBO\StructType\ProfessionalCompetenceType[] $professionalCompetence
     * @param \KBO\StructType\QualificationType[] $qualification
     * @param \KBO\StructType\AuthorizationType[] $authorization
     * @param \KBO\StructType\ActivityType[] $activity
     * @param \KBO\StructType\FunctionType[] $function
     * @param \KBO\StructType\LinkedEnterpriseType[] $linkedEnterprise
     * @param \KBO\StructType\FinancialDataType $financialData
     * @param \KBO\StructType\ReplacementType[] $replacement
     * @param \KBO\StructType\ExOfficioStrikingOffType[] $exOfficioStrikingOff
     */
    public function __construct($number = null, \KBO\StructType\JuridicalSituationType $juridicalSituation = null, \KBO\StructType\PeriodType $period = null, $duration = null, $typeOfEnterprise = null, \KBO\StructType\JuridicalFormType $juridicalForm = null, \KBO\StructType\CapitalType $capital = null, array $primaryDenomination = array(), array $denomination = array(), array $address = array(), array $contactInformation = array(), $businessUnits = null, array $branch = array(), array $professionalCompetence = array(), array $qualification = array(), array $authorization = array(), array $activity = array(), array $function = array(), array $linkedEnterprise = array(), \KBO\StructType\FinancialDataType $financialData = null, array $replacement = array(), array $exOfficioStrikingOff = array())
    {
        $this
            ->setNumber($number)
            ->setJuridicalSituation($juridicalSituation)
            ->setPeriod($period)
            ->setDuration($duration)
            ->setTypeOfEnterprise($typeOfEnterprise)
            ->setJuridicalForm($juridicalForm)
            ->setCapital($capital)
            ->setPrimaryDenomination($primaryDenomination)
            ->setDenomination($denomination)
            ->setAddress($address)
            ->setContactInformation($contactInformation)
            ->setBusinessUnits($businessUnits)
            ->setBranch($branch)
            ->setProfessionalCompetence($professionalCompetence)
            ->setQualification($qualification)
            ->setAuthorization($authorization)
            ->setActivity($activity)
            ->setFunction($function)
            ->setLinkedEnterprise($linkedEnterprise)
            ->setFinancialData($financialData)
            ->setReplacement($replacement)
            ->setExOfficioStrikingOff($exOfficioStrikingOff);
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \KBO\StructType\EnterpriseType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: pattern([01]?[0-9]{9})
        if (!is_null($number) && !preg_match('/[01]?[0-9]{9}/', $number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [01]?[0-9]{9}', var_export($number, true)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get JuridicalSituation value
     * @return \KBO\StructType\JuridicalSituationType|null
     */
    public function getJuridicalSituation()
    {
        return $this->JuridicalSituation;
    }
    /**
     * Set JuridicalSituation value
     * @param \KBO\StructType\JuridicalSituationType $juridicalSituation
     * @return \KBO\StructType\EnterpriseType
     */
    public function setJuridicalSituation(\KBO\StructType\JuridicalSituationType $juridicalSituation = null)
    {
        $this->JuridicalSituation = $juridicalSituation;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\EnterpriseType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \KBO\StructType\EnterpriseType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get TypeOfEnterprise value
     * @return string|null
     */
    public function getTypeOfEnterprise()
    {
        return $this->TypeOfEnterprise;
    }
    /**
     * Set TypeOfEnterprise value
     * @uses \KBO\EnumType\Type::valueIsValid()
     * @uses \KBO\EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeOfEnterprise
     * @return \KBO\StructType\EnterpriseType
     */
    public function setTypeOfEnterprise($typeOfEnterprise = null)
    {
        // validation for constraint: enumeration
        if (!\KBO\EnumType\Type::valueIsValid($typeOfEnterprise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \KBO\EnumType\Type', is_array($typeOfEnterprise) ? implode(', ', $typeOfEnterprise) : var_export($typeOfEnterprise, true), implode(', ', \KBO\EnumType\Type::getValidValues())), __LINE__);
        }
        $this->TypeOfEnterprise = $typeOfEnterprise;
        return $this;
    }
    /**
     * Get JuridicalForm value
     * @return \KBO\StructType\JuridicalFormType|null
     */
    public function getJuridicalForm()
    {
        return $this->JuridicalForm;
    }
    /**
     * Set JuridicalForm value
     * @param \KBO\StructType\JuridicalFormType $juridicalForm
     * @return \KBO\StructType\EnterpriseType
     */
    public function setJuridicalForm(\KBO\StructType\JuridicalFormType $juridicalForm = null)
    {
        $this->JuridicalForm = $juridicalForm;
        return $this;
    }
    /**
     * Get Capital value
     * @return \KBO\StructType\CapitalType|null
     */
    public function getCapital()
    {
        return $this->Capital;
    }
    /**
     * Set Capital value
     * @param \KBO\StructType\CapitalType $capital
     * @return \KBO\StructType\EnterpriseType
     */
    public function setCapital(\KBO\StructType\CapitalType $capital = null)
    {
        $this->Capital = $capital;
        return $this;
    }
    /**
     * Get PrimaryDenomination value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getPrimaryDenomination()
    {
        return $this->PrimaryDenomination;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimaryDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimaryDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypePrimaryDenominationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypePrimaryDenominationItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($enterpriseTypePrimaryDenominationItem) ? get_class($enterpriseTypePrimaryDenominationItem) : sprintf('%s(%s)', gettype($enterpriseTypePrimaryDenominationItem), var_export($enterpriseTypePrimaryDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrimaryDenomination property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $primaryDenomination
     * @return \KBO\StructType\EnterpriseType
     */
    public function setPrimaryDenomination(array $primaryDenomination = array())
    {
        // validation for constraint: array
        if ('' !== ($primaryDenominationArrayErrorMessage = self::validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination($primaryDenomination))) {
            throw new \InvalidArgumentException($primaryDenominationArrayErrorMessage, __LINE__);
        }
        $this->PrimaryDenomination = $primaryDenomination;
        return $this;
    }
    /**
     * Add item to PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToPrimaryDenomination(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The PrimaryDenomination property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrimaryDenomination[] = $item;
        return $this;
    }
    /**
     * Get Denomination value
     * @return \KBO\StructType\DenominationType[]|null
     */
    public function getDenomination()
    {
        return $this->Denomination;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeDenominationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeDenominationItem instanceof \KBO\StructType\DenominationType) {
                $invalidValues[] = is_object($enterpriseTypeDenominationItem) ? get_class($enterpriseTypeDenominationItem) : sprintf('%s(%s)', gettype($enterpriseTypeDenominationItem), var_export($enterpriseTypeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Denomination property can only contain items of type \KBO\StructType\DenominationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Denomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DenominationType[] $denomination
     * @return \KBO\StructType\EnterpriseType
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        $this->Denomination = $denomination;
        return $this;
    }
    /**
     * Add item to Denomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DenominationType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToDenomination(\KBO\StructType\DenominationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DenominationType) {
            throw new \InvalidArgumentException(sprintf('The Denomination property can only contain items of type \KBO\StructType\DenominationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Denomination[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \KBO\StructType\AddressType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeAddressItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeAddressItem instanceof \KBO\StructType\AddressType) {
                $invalidValues[] = is_object($enterpriseTypeAddressItem) ? get_class($enterpriseTypeAddressItem) : sprintf('%s(%s)', gettype($enterpriseTypeAddressItem), var_export($enterpriseTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \KBO\StructType\AddressType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\AddressType[] $address
     * @return \KBO\StructType\EnterpriseType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($address) && count($address) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\AddressType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToAddress(\KBO\StructType\AddressType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\AddressType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \KBO\StructType\AddressType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->Address) && count($this->Address) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return \KBO\StructType\ContactInformationType[]|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInformationForArrayConstraintsFromSetContactInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeContactInformationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeContactInformationItem instanceof \KBO\StructType\ContactInformationType) {
                $invalidValues[] = is_object($enterpriseTypeContactInformationItem) ? get_class($enterpriseTypeContactInformationItem) : sprintf('%s(%s)', gettype($enterpriseTypeContactInformationItem), var_export($enterpriseTypeContactInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInformation property can only contain items of type \KBO\StructType\ContactInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInformation value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ContactInformationType[] $contactInformation
     * @return \KBO\StructType\EnterpriseType
     */
    public function setContactInformation(array $contactInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInformationArrayErrorMessage = self::validateContactInformationForArrayConstraintsFromSetContactInformation($contactInformation))) {
            throw new \InvalidArgumentException($contactInformationArrayErrorMessage, __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Add item to ContactInformation value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ContactInformationType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToContactInformation(\KBO\StructType\ContactInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ContactInformationType) {
            throw new \InvalidArgumentException(sprintf('The ContactInformation property can only contain items of type \KBO\StructType\ContactInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInformation[] = $item;
        return $this;
    }
    /**
     * Get BusinessUnits value
     * @return int|null
     */
    public function getBusinessUnits()
    {
        return $this->BusinessUnits;
    }
    /**
     * Set BusinessUnits value
     * @param int $businessUnits
     * @return \KBO\StructType\EnterpriseType
     */
    public function setBusinessUnits($businessUnits = null)
    {
        // validation for constraint: int
        if (!is_null($businessUnits) && !(is_int($businessUnits) || ctype_digit($businessUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($businessUnits, true), gettype($businessUnits)), __LINE__);
        }
        $this->BusinessUnits = $businessUnits;
        return $this;
    }
    /**
     * Get Branch value
     * @return \KBO\StructType\BranchType[]|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * This method is responsible for validating the values passed to the setBranch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBranch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBranchForArrayConstraintsFromSetBranch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeBranchItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeBranchItem instanceof \KBO\StructType\BranchType) {
                $invalidValues[] = is_object($enterpriseTypeBranchItem) ? get_class($enterpriseTypeBranchItem) : sprintf('%s(%s)', gettype($enterpriseTypeBranchItem), var_export($enterpriseTypeBranchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Branch property can only contain items of type \KBO\StructType\BranchType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Branch value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\BranchType[] $branch
     * @return \KBO\StructType\EnterpriseType
     */
    public function setBranch(array $branch = array())
    {
        // validation for constraint: array
        if ('' !== ($branchArrayErrorMessage = self::validateBranchForArrayConstraintsFromSetBranch($branch))) {
            throw new \InvalidArgumentException($branchArrayErrorMessage, __LINE__);
        }
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Add item to Branch value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\BranchType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToBranch(\KBO\StructType\BranchType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\BranchType) {
            throw new \InvalidArgumentException(sprintf('The Branch property can only contain items of type \KBO\StructType\BranchType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Branch[] = $item;
        return $this;
    }
    /**
     * Get ProfessionalCompetence value
     * @return \KBO\StructType\ProfessionalCompetenceType[]|null
     */
    public function getProfessionalCompetence()
    {
        return $this->ProfessionalCompetence;
    }
    /**
     * This method is responsible for validating the values passed to the setProfessionalCompetence method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfessionalCompetence method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfessionalCompetenceForArrayConstraintsFromSetProfessionalCompetence(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeProfessionalCompetenceItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeProfessionalCompetenceItem instanceof \KBO\StructType\ProfessionalCompetenceType) {
                $invalidValues[] = is_object($enterpriseTypeProfessionalCompetenceItem) ? get_class($enterpriseTypeProfessionalCompetenceItem) : sprintf('%s(%s)', gettype($enterpriseTypeProfessionalCompetenceItem), var_export($enterpriseTypeProfessionalCompetenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfessionalCompetence property can only contain items of type \KBO\StructType\ProfessionalCompetenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfessionalCompetence value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ProfessionalCompetenceType[] $professionalCompetence
     * @return \KBO\StructType\EnterpriseType
     */
    public function setProfessionalCompetence(array $professionalCompetence = array())
    {
        // validation for constraint: array
        if ('' !== ($professionalCompetenceArrayErrorMessage = self::validateProfessionalCompetenceForArrayConstraintsFromSetProfessionalCompetence($professionalCompetence))) {
            throw new \InvalidArgumentException($professionalCompetenceArrayErrorMessage, __LINE__);
        }
        $this->ProfessionalCompetence = $professionalCompetence;
        return $this;
    }
    /**
     * Add item to ProfessionalCompetence value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ProfessionalCompetenceType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToProfessionalCompetence(\KBO\StructType\ProfessionalCompetenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ProfessionalCompetenceType) {
            throw new \InvalidArgumentException(sprintf('The ProfessionalCompetence property can only contain items of type \KBO\StructType\ProfessionalCompetenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProfessionalCompetence[] = $item;
        return $this;
    }
    /**
     * Get Qualification value
     * @return \KBO\StructType\QualificationType[]|null
     */
    public function getQualification()
    {
        return $this->Qualification;
    }
    /**
     * This method is responsible for validating the values passed to the setQualification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQualification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQualificationForArrayConstraintsFromSetQualification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeQualificationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeQualificationItem instanceof \KBO\StructType\QualificationType) {
                $invalidValues[] = is_object($enterpriseTypeQualificationItem) ? get_class($enterpriseTypeQualificationItem) : sprintf('%s(%s)', gettype($enterpriseTypeQualificationItem), var_export($enterpriseTypeQualificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Qualification property can only contain items of type \KBO\StructType\QualificationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Qualification value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\QualificationType[] $qualification
     * @return \KBO\StructType\EnterpriseType
     */
    public function setQualification(array $qualification = array())
    {
        // validation for constraint: array
        if ('' !== ($qualificationArrayErrorMessage = self::validateQualificationForArrayConstraintsFromSetQualification($qualification))) {
            throw new \InvalidArgumentException($qualificationArrayErrorMessage, __LINE__);
        }
        $this->Qualification = $qualification;
        return $this;
    }
    /**
     * Add item to Qualification value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\QualificationType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToQualification(\KBO\StructType\QualificationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\QualificationType) {
            throw new \InvalidArgumentException(sprintf('The Qualification property can only contain items of type \KBO\StructType\QualificationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Qualification[] = $item;
        return $this;
    }
    /**
     * Get Authorization value
     * @return \KBO\StructType\AuthorizationType[]|null
     */
    public function getAuthorization()
    {
        return $this->Authorization;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizationForArrayConstraintsFromSetAuthorization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeAuthorizationItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeAuthorizationItem instanceof \KBO\StructType\AuthorizationType) {
                $invalidValues[] = is_object($enterpriseTypeAuthorizationItem) ? get_class($enterpriseTypeAuthorizationItem) : sprintf('%s(%s)', gettype($enterpriseTypeAuthorizationItem), var_export($enterpriseTypeAuthorizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Authorization property can only contain items of type \KBO\StructType\AuthorizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Authorization value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\AuthorizationType[] $authorization
     * @return \KBO\StructType\EnterpriseType
     */
    public function setAuthorization(array $authorization = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizationArrayErrorMessage = self::validateAuthorizationForArrayConstraintsFromSetAuthorization($authorization))) {
            throw new \InvalidArgumentException($authorizationArrayErrorMessage, __LINE__);
        }
        $this->Authorization = $authorization;
        return $this;
    }
    /**
     * Add item to Authorization value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\AuthorizationType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToAuthorization(\KBO\StructType\AuthorizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\AuthorizationType) {
            throw new \InvalidArgumentException(sprintf('The Authorization property can only contain items of type \KBO\StructType\AuthorizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Authorization[] = $item;
        return $this;
    }
    /**
     * Get Activity value
     * @return \KBO\StructType\ActivityType[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeActivityItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeActivityItem instanceof \KBO\StructType\ActivityType) {
                $invalidValues[] = is_object($enterpriseTypeActivityItem) ? get_class($enterpriseTypeActivityItem) : sprintf('%s(%s)', gettype($enterpriseTypeActivityItem), var_export($enterpriseTypeActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \KBO\StructType\ActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ActivityType[] $activity
     * @return \KBO\StructType\EnterpriseType
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ActivityType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToActivity(\KBO\StructType\ActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ActivityType) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \KBO\StructType\ActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
    /**
     * Get Function value
     * @return \KBO\StructType\FunctionType[]|null
     */
    public function getFunction()
    {
        return $this->Function;
    }
    /**
     * This method is responsible for validating the values passed to the setFunction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFunction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFunctionForArrayConstraintsFromSetFunction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeFunctionItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeFunctionItem instanceof \KBO\StructType\FunctionType) {
                $invalidValues[] = is_object($enterpriseTypeFunctionItem) ? get_class($enterpriseTypeFunctionItem) : sprintf('%s(%s)', gettype($enterpriseTypeFunctionItem), var_export($enterpriseTypeFunctionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Function property can only contain items of type \KBO\StructType\FunctionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Function value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\FunctionType[] $function
     * @return \KBO\StructType\EnterpriseType
     */
    public function setFunction(array $function = array())
    {
        // validation for constraint: array
        if ('' !== ($functionArrayErrorMessage = self::validateFunctionForArrayConstraintsFromSetFunction($function))) {
            throw new \InvalidArgumentException($functionArrayErrorMessage, __LINE__);
        }
        $this->Function = $function;
        return $this;
    }
    /**
     * Add item to Function value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\FunctionType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToFunction(\KBO\StructType\FunctionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\FunctionType) {
            throw new \InvalidArgumentException(sprintf('The Function property can only contain items of type \KBO\StructType\FunctionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Function[] = $item;
        return $this;
    }
    /**
     * Get LinkedEnterprise value
     * @return \KBO\StructType\LinkedEnterpriseType[]|null
     */
    public function getLinkedEnterprise()
    {
        return $this->LinkedEnterprise;
    }
    /**
     * This method is responsible for validating the values passed to the setLinkedEnterprise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLinkedEnterprise method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkedEnterpriseForArrayConstraintsFromSetLinkedEnterprise(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeLinkedEnterpriseItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeLinkedEnterpriseItem instanceof \KBO\StructType\LinkedEnterpriseType) {
                $invalidValues[] = is_object($enterpriseTypeLinkedEnterpriseItem) ? get_class($enterpriseTypeLinkedEnterpriseItem) : sprintf('%s(%s)', gettype($enterpriseTypeLinkedEnterpriseItem), var_export($enterpriseTypeLinkedEnterpriseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LinkedEnterprise property can only contain items of type \KBO\StructType\LinkedEnterpriseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LinkedEnterprise value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\LinkedEnterpriseType[] $linkedEnterprise
     * @return \KBO\StructType\EnterpriseType
     */
    public function setLinkedEnterprise(array $linkedEnterprise = array())
    {
        // validation for constraint: array
        if ('' !== ($linkedEnterpriseArrayErrorMessage = self::validateLinkedEnterpriseForArrayConstraintsFromSetLinkedEnterprise($linkedEnterprise))) {
            throw new \InvalidArgumentException($linkedEnterpriseArrayErrorMessage, __LINE__);
        }
        $this->LinkedEnterprise = $linkedEnterprise;
        return $this;
    }
    /**
     * Add item to LinkedEnterprise value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\LinkedEnterpriseType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToLinkedEnterprise(\KBO\StructType\LinkedEnterpriseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\LinkedEnterpriseType) {
            throw new \InvalidArgumentException(sprintf('The LinkedEnterprise property can only contain items of type \KBO\StructType\LinkedEnterpriseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LinkedEnterprise[] = $item;
        return $this;
    }
    /**
     * Get FinancialData value
     * @return \KBO\StructType\FinancialDataType|null
     */
    public function getFinancialData()
    {
        return $this->FinancialData;
    }
    /**
     * Set FinancialData value
     * @param \KBO\StructType\FinancialDataType $financialData
     * @return \KBO\StructType\EnterpriseType
     */
    public function setFinancialData(\KBO\StructType\FinancialDataType $financialData = null)
    {
        $this->FinancialData = $financialData;
        return $this;
    }
    /**
     * Get Replacement value
     * @return \KBO\StructType\ReplacementType[]|null
     */
    public function getReplacement()
    {
        return $this->Replacement;
    }
    /**
     * This method is responsible for validating the values passed to the setReplacement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReplacement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReplacementForArrayConstraintsFromSetReplacement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeReplacementItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeReplacementItem instanceof \KBO\StructType\ReplacementType) {
                $invalidValues[] = is_object($enterpriseTypeReplacementItem) ? get_class($enterpriseTypeReplacementItem) : sprintf('%s(%s)', gettype($enterpriseTypeReplacementItem), var_export($enterpriseTypeReplacementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Replacement property can only contain items of type \KBO\StructType\ReplacementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Replacement value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ReplacementType[] $replacement
     * @return \KBO\StructType\EnterpriseType
     */
    public function setReplacement(array $replacement = array())
    {
        // validation for constraint: array
        if ('' !== ($replacementArrayErrorMessage = self::validateReplacementForArrayConstraintsFromSetReplacement($replacement))) {
            throw new \InvalidArgumentException($replacementArrayErrorMessage, __LINE__);
        }
        $this->Replacement = $replacement;
        return $this;
    }
    /**
     * Add item to Replacement value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ReplacementType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToReplacement(\KBO\StructType\ReplacementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ReplacementType) {
            throw new \InvalidArgumentException(sprintf('The Replacement property can only contain items of type \KBO\StructType\ReplacementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Replacement[] = $item;
        return $this;
    }
    /**
     * Get ExOfficioStrikingOff value
     * @return \KBO\StructType\ExOfficioStrikingOffType[]|null
     */
    public function getExOfficioStrikingOff()
    {
        return $this->ExOfficioStrikingOff;
    }
    /**
     * This method is responsible for validating the values passed to the setExOfficioStrikingOff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExOfficioStrikingOff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExOfficioStrikingOffForArrayConstraintsFromSetExOfficioStrikingOff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $enterpriseTypeExOfficioStrikingOffItem) {
            // validation for constraint: itemType
            if (!$enterpriseTypeExOfficioStrikingOffItem instanceof \KBO\StructType\ExOfficioStrikingOffType) {
                $invalidValues[] = is_object($enterpriseTypeExOfficioStrikingOffItem) ? get_class($enterpriseTypeExOfficioStrikingOffItem) : sprintf('%s(%s)', gettype($enterpriseTypeExOfficioStrikingOffItem), var_export($enterpriseTypeExOfficioStrikingOffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExOfficioStrikingOff property can only contain items of type \KBO\StructType\ExOfficioStrikingOffType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ExOfficioStrikingOffType[] $exOfficioStrikingOff
     * @return \KBO\StructType\EnterpriseType
     */
    public function setExOfficioStrikingOff(array $exOfficioStrikingOff = array())
    {
        // validation for constraint: array
        if ('' !== ($exOfficioStrikingOffArrayErrorMessage = self::validateExOfficioStrikingOffForArrayConstraintsFromSetExOfficioStrikingOff($exOfficioStrikingOff))) {
            throw new \InvalidArgumentException($exOfficioStrikingOffArrayErrorMessage, __LINE__);
        }
        $this->ExOfficioStrikingOff = $exOfficioStrikingOff;
        return $this;
    }
    /**
     * Add item to ExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ExOfficioStrikingOffType $item
     * @return \KBO\StructType\EnterpriseType
     */
    public function addToExOfficioStrikingOff(\KBO\StructType\ExOfficioStrikingOffType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ExOfficioStrikingOffType) {
            throw new \InvalidArgumentException(sprintf('The ExOfficioStrikingOff property can only contain items of type \KBO\StructType\ExOfficioStrikingOffType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExOfficioStrikingOff[] = $item;
        return $this;
    }
}
