<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadCodeListReplyType StructType
 * @subpackage Structs
 */
class ReadCodeListReplyType extends AbstractStructBase
{
    /**
     * The CodeListItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\CodeListItemType[]
     */
    public $CodeListItem;
    /**
     * Constructor method for ReadCodeListReplyType
     * @uses ReadCodeListReplyType::setCodeListItem()
     * @param \KBO\StructType\CodeListItemType[] $codeListItem
     */
    public function __construct(array $codeListItem = array())
    {
        $this
            ->setCodeListItem($codeListItem);
    }
    /**
     * Get CodeListItem value
     * @return \KBO\StructType\CodeListItemType[]|null
     */
    public function getCodeListItem()
    {
        return $this->CodeListItem;
    }
    /**
     * This method is responsible for validating the values passed to the setCodeListItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodeListItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodeListItemForArrayConstraintsFromSetCodeListItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readCodeListReplyTypeCodeListItemItem) {
            // validation for constraint: itemType
            if (!$readCodeListReplyTypeCodeListItemItem instanceof \KBO\StructType\CodeListItemType) {
                $invalidValues[] = is_object($readCodeListReplyTypeCodeListItemItem) ? get_class($readCodeListReplyTypeCodeListItemItem) : sprintf('%s(%s)', gettype($readCodeListReplyTypeCodeListItemItem), var_export($readCodeListReplyTypeCodeListItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CodeListItem property can only contain items of type \KBO\StructType\CodeListItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CodeListItem value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\CodeListItemType[] $codeListItem
     * @return \KBO\StructType\ReadCodeListReplyType
     */
    public function setCodeListItem(array $codeListItem = array())
    {
        // validation for constraint: array
        if ('' !== ($codeListItemArrayErrorMessage = self::validateCodeListItemForArrayConstraintsFromSetCodeListItem($codeListItem))) {
            throw new \InvalidArgumentException($codeListItemArrayErrorMessage, __LINE__);
        }
        $this->CodeListItem = $codeListItem;
        return $this;
    }
    /**
     * Add item to CodeListItem value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\CodeListItemType $item
     * @return \KBO\StructType\ReadCodeListReplyType
     */
    public function addToCodeListItem(\KBO\StructType\CodeListItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\CodeListItemType) {
            throw new \InvalidArgumentException(sprintf('The CodeListItem property can only contain items of type \KBO\StructType\CodeListItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CodeListItem[] = $item;
        return $this;
    }
}
