<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadStreetNameReplyType StructType
 * @subpackage Structs
 */
class ReadStreetNameReplyType extends AbstractStructBase
{
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - maxOccurs: unbounded
     * - minLength: 2
     * - minOccurs: 0
     * @var string[]
     */
    public $StreetName;
    /**
     * Constructor method for ReadStreetNameReplyType
     * @uses ReadStreetNameReplyType::setStreetName()
     * @param string[] $streetName
     */
    public function __construct(array $streetName = array())
    {
        $this
            ->setStreetName($streetName);
    }
    /**
     * Get StreetName value
     * @return string[]|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * This method is responsible for validating the values passed to the setStreetName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetNameForArrayConstraintsFromSetStreetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readStreetNameReplyTypeStreetNameItem) {
            // validation for constraint: itemType
            if (!is_string($readStreetNameReplyTypeStreetNameItem)) {
                $invalidValues[] = is_object($readStreetNameReplyTypeStreetNameItem) ? get_class($readStreetNameReplyTypeStreetNameItem) : sprintf('%s(%s)', gettype($readStreetNameReplyTypeStreetNameItem), var_export($readStreetNameReplyTypeStreetNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StreetName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setStreetName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetNameForMaxLengthConstraintFromSetStreetName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readStreetNameReplyTypeStreetNameItem) {
            // validation for constraint: maxLength(32)
            if (mb_strlen($readStreetNameReplyTypeStreetNameItem) > 32) {
                $invalidValues[] = var_export($readStreetNameReplyTypeStreetNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 32', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setStreetName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStreetName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStreetNameForMinLengthConstraintFromSetStreetName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readStreetNameReplyTypeStreetNameItem) {
            // validation for constraint: minLength(2)
            if (mb_strlen($readStreetNameReplyTypeStreetNameItem) < 2) {
                $invalidValues[] = var_export($readStreetNameReplyTypeStreetNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 2', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StreetName value
     * @throws \InvalidArgumentException
     * @param string[] $streetName
     * @return \KBO\StructType\ReadStreetNameReplyType
     */
    public function setStreetName(array $streetName = array())
    {
        // validation for constraint: array
        if ('' !== ($streetNameArrayErrorMessage = self::validateStreetNameForArrayConstraintsFromSetStreetName($streetName))) {
            throw new \InvalidArgumentException($streetNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(32)
        if ('' !== ($streetNameMaxLengthErrorMessage = self::validateStreetNameForMaxLengthConstraintFromSetStreetName($streetName))) {
            throw new \InvalidArgumentException($streetNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: minLength(2)
        if ('' !== ($streetNameMinLengthErrorMessage = self::validateStreetNameForMinLengthConstraintFromSetStreetName($streetName))) {
            throw new \InvalidArgumentException($streetNameMinLengthErrorMessage, __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Add item to StreetName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \KBO\StructType\ReadStreetNameReplyType
     */
    public function addToStreetName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The StreetName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (mb_strlen($item) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (mb_strlen($item) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($item)), __LINE__);
        }
        $this->StreetName[] = $item;
        return $this;
    }
}
