<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType StructType
 * @subpackage Structs
 */
class ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 160
     * - whiteSpace: collapse
     * @var string
     */
    public $CompanyName;
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - minOccurs: 0
     * - pattern: \d{4}
     * @var string
     */
    public $Zipcode;
    /**
     * The EnterpriseJuridicalForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\JuridicalFormType
     */
    public $EnterpriseJuridicalForm;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for
     * ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType
     * @uses ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType::setCompanyName()
     * @uses ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType::setZipcode()
     * @uses ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType::setEnterpriseJuridicalForm()
     * @uses ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType::setActiveFilter()
     * @param string $companyName
     * @param string $zipcode
     * @param \KBO\StructType\JuridicalFormType $enterpriseJuridicalForm
     * @param bool $activeFilter
     */
    public function __construct($companyName = null, $zipcode = null, \KBO\StructType\JuridicalFormType $enterpriseJuridicalForm = null, $activeFilter = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setZipcode($zipcode)
            ->setEnterpriseJuridicalForm($enterpriseJuridicalForm)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyName, true), gettype($companyName)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($companyName) && mb_strlen($companyName) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get EnterpriseJuridicalForm value
     * @return \KBO\StructType\JuridicalFormType|null
     */
    public function getEnterpriseJuridicalForm()
    {
        return $this->EnterpriseJuridicalForm;
    }
    /**
     * Set EnterpriseJuridicalForm value
     * @param \KBO\StructType\JuridicalFormType $enterpriseJuridicalForm
     * @return \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType
     */
    public function setEnterpriseJuridicalForm(\KBO\StructType\JuridicalFormType $enterpriseJuridicalForm = null)
    {
        $this->EnterpriseJuridicalForm = $enterpriseJuridicalForm;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
