<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEnterpriseByPhysicalPersonNameExactMatchRequestType
 * StructType
 * @subpackage Structs
 */
class ReadEnterpriseByPhysicalPersonNameExactMatchRequestType extends AbstractStructBase
{
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 160
     * - whiteSpace: collapse
     * @var string
     */
    public $LastName;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 160
     * - minOccurs: 0
     * - whiteSpace: collapse
     * @var string
     */
    public $FirstName;
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - minOccurs: 0
     * - pattern: \d{4}
     * @var string
     */
    public $Zipcode;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for ReadEnterpriseByPhysicalPersonNameExactMatchRequestType
     * @uses ReadEnterpriseByPhysicalPersonNameExactMatchRequestType::setLastName()
     * @uses ReadEnterpriseByPhysicalPersonNameExactMatchRequestType::setFirstName()
     * @uses ReadEnterpriseByPhysicalPersonNameExactMatchRequestType::setZipcode()
     * @uses ReadEnterpriseByPhysicalPersonNameExactMatchRequestType::setActiveFilter()
     * @param string $lastName
     * @param string $firstName
     * @param string $zipcode
     * @param bool $activeFilter
     */
    public function __construct($lastName = null, $firstName = null, $zipcode = null, $activeFilter = null)
    {
        $this
            ->setLastName($lastName)
            ->setFirstName($firstName)
            ->setZipcode($zipcode)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($lastName) && mb_strlen($lastName) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (!is_null($firstName) && mb_strlen($firstName) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
