<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstablishmentType StructType
 * @subpackage Structs
 */
class EstablishmentType extends AbstractStructBase
{
    /**
     * The EstablishmentNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - pattern: [2-9][0-9]{9}
     * @var int
     */
    public $EstablishmentNumber;
    /**
     * The Status
     * @var \KBO\StructType\StatusType
     */
    public $Status;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * The EnterpriseNumber
     * Meta information extracted from the WSDL
     * - base: xs:long
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [01]?[0-9]{9}
     * @var int
     */
    public $EnterpriseNumber;
    /**
     * The EnterpriseStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \KBO\StructType\StatusType
     */
    public $EnterpriseStatus;
    /**
     * The EnterpriseExOfficioStrikingOff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ExOfficioStrikingOffType[]
     */
    public $EnterpriseExOfficioStrikingOff;
    /**
     * The PrimaryDenomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\DescriptionType[]
     */
    public $PrimaryDenomination;
    /**
     * The Denomination
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\DenominationType[]
     */
    public $Denomination;
    /**
     * The Address
     * @var \KBO\StructType\AddressType
     */
    public $Address;
    /**
     * The ContactInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ContactInformationType[]
     */
    public $ContactInformation;
    /**
     * The Authorization
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\AuthorizationType[]
     */
    public $Authorization;
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KBO\StructType\ActivityType[]
     */
    public $Activity;
    /**
     * Constructor method for EstablishmentType
     * @uses EstablishmentType::setEstablishmentNumber()
     * @uses EstablishmentType::setStatus()
     * @uses EstablishmentType::setPeriod()
     * @uses EstablishmentType::setEnterpriseNumber()
     * @uses EstablishmentType::setEnterpriseStatus()
     * @uses EstablishmentType::setEnterpriseExOfficioStrikingOff()
     * @uses EstablishmentType::setPrimaryDenomination()
     * @uses EstablishmentType::setDenomination()
     * @uses EstablishmentType::setAddress()
     * @uses EstablishmentType::setContactInformation()
     * @uses EstablishmentType::setAuthorization()
     * @uses EstablishmentType::setActivity()
     * @param int $establishmentNumber
     * @param \KBO\StructType\StatusType $status
     * @param \KBO\StructType\PeriodType $period
     * @param int $enterpriseNumber
     * @param \KBO\StructType\StatusType $enterpriseStatus
     * @param \KBO\StructType\ExOfficioStrikingOffType[] $enterpriseExOfficioStrikingOff
     * @param \KBO\StructType\DescriptionType[] $primaryDenomination
     * @param \KBO\StructType\DenominationType[] $denomination
     * @param \KBO\StructType\AddressType $address
     * @param \KBO\StructType\ContactInformationType[] $contactInformation
     * @param \KBO\StructType\AuthorizationType[] $authorization
     * @param \KBO\StructType\ActivityType[] $activity
     */
    public function __construct($establishmentNumber = null, \KBO\StructType\StatusType $status = null, \KBO\StructType\PeriodType $period = null, $enterpriseNumber = null, \KBO\StructType\StatusType $enterpriseStatus = null, array $enterpriseExOfficioStrikingOff = array(), array $primaryDenomination = array(), array $denomination = array(), \KBO\StructType\AddressType $address = null, array $contactInformation = array(), array $authorization = array(), array $activity = array())
    {
        $this
            ->setEstablishmentNumber($establishmentNumber)
            ->setStatus($status)
            ->setPeriod($period)
            ->setEnterpriseNumber($enterpriseNumber)
            ->setEnterpriseStatus($enterpriseStatus)
            ->setEnterpriseExOfficioStrikingOff($enterpriseExOfficioStrikingOff)
            ->setPrimaryDenomination($primaryDenomination)
            ->setDenomination($denomination)
            ->setAddress($address)
            ->setContactInformation($contactInformation)
            ->setAuthorization($authorization)
            ->setActivity($activity);
    }
    /**
     * Get EstablishmentNumber value
     * @return int|null
     */
    public function getEstablishmentNumber()
    {
        return $this->EstablishmentNumber;
    }
    /**
     * Set EstablishmentNumber value
     * @param int $establishmentNumber
     * @return \KBO\StructType\EstablishmentType
     */
    public function setEstablishmentNumber($establishmentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($establishmentNumber) && !(is_int($establishmentNumber) || ctype_digit($establishmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($establishmentNumber, true), gettype($establishmentNumber)), __LINE__);
        }
        // validation for constraint: pattern([2-9][0-9]{9})
        if (!is_null($establishmentNumber) && !preg_match('/[2-9][0-9]{9}/', $establishmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [2-9][0-9]{9}', var_export($establishmentNumber, true)), __LINE__);
        }
        $this->EstablishmentNumber = $establishmentNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return \KBO\StructType\StatusType|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \KBO\StructType\StatusType $status
     * @return \KBO\StructType\EstablishmentType
     */
    public function setStatus(\KBO\StructType\StatusType $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\EstablishmentType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get EnterpriseNumber value
     * @return int|null
     */
    public function getEnterpriseNumber()
    {
        return $this->EnterpriseNumber;
    }
    /**
     * Set EnterpriseNumber value
     * @param int $enterpriseNumber
     * @return \KBO\StructType\EstablishmentType
     */
    public function setEnterpriseNumber($enterpriseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumber) && !(is_int($enterpriseNumber) || ctype_digit($enterpriseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumber, true), gettype($enterpriseNumber)), __LINE__);
        }
        // validation for constraint: pattern([01]?[0-9]{9})
        if (!is_null($enterpriseNumber) && !preg_match('/[01]?[0-9]{9}/', $enterpriseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [01]?[0-9]{9}', var_export($enterpriseNumber, true)), __LINE__);
        }
        $this->EnterpriseNumber = $enterpriseNumber;
        return $this;
    }
    /**
     * Get EnterpriseStatus value
     * @return \KBO\StructType\StatusType|null
     */
    public function getEnterpriseStatus()
    {
        return $this->EnterpriseStatus;
    }
    /**
     * Set EnterpriseStatus value
     * @param \KBO\StructType\StatusType $enterpriseStatus
     * @return \KBO\StructType\EstablishmentType
     */
    public function setEnterpriseStatus(\KBO\StructType\StatusType $enterpriseStatus = null)
    {
        $this->EnterpriseStatus = $enterpriseStatus;
        return $this;
    }
    /**
     * Get EnterpriseExOfficioStrikingOff value
     * @return \KBO\StructType\ExOfficioStrikingOffType[]|null
     */
    public function getEnterpriseExOfficioStrikingOff()
    {
        return $this->EnterpriseExOfficioStrikingOff;
    }
    /**
     * This method is responsible for validating the values passed to the setEnterpriseExOfficioStrikingOff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnterpriseExOfficioStrikingOff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEnterpriseExOfficioStrikingOffForArrayConstraintsFromSetEnterpriseExOfficioStrikingOff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeEnterpriseExOfficioStrikingOffItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeEnterpriseExOfficioStrikingOffItem instanceof \KBO\StructType\ExOfficioStrikingOffType) {
                $invalidValues[] = is_object($establishmentTypeEnterpriseExOfficioStrikingOffItem) ? get_class($establishmentTypeEnterpriseExOfficioStrikingOffItem) : sprintf('%s(%s)', gettype($establishmentTypeEnterpriseExOfficioStrikingOffItem), var_export($establishmentTypeEnterpriseExOfficioStrikingOffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EnterpriseExOfficioStrikingOff property can only contain items of type \KBO\StructType\ExOfficioStrikingOffType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EnterpriseExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ExOfficioStrikingOffType[] $enterpriseExOfficioStrikingOff
     * @return \KBO\StructType\EstablishmentType
     */
    public function setEnterpriseExOfficioStrikingOff(array $enterpriseExOfficioStrikingOff = array())
    {
        // validation for constraint: array
        if ('' !== ($enterpriseExOfficioStrikingOffArrayErrorMessage = self::validateEnterpriseExOfficioStrikingOffForArrayConstraintsFromSetEnterpriseExOfficioStrikingOff($enterpriseExOfficioStrikingOff))) {
            throw new \InvalidArgumentException($enterpriseExOfficioStrikingOffArrayErrorMessage, __LINE__);
        }
        $this->EnterpriseExOfficioStrikingOff = $enterpriseExOfficioStrikingOff;
        return $this;
    }
    /**
     * Add item to EnterpriseExOfficioStrikingOff value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ExOfficioStrikingOffType $item
     * @return \KBO\StructType\EstablishmentType
     */
    public function addToEnterpriseExOfficioStrikingOff(\KBO\StructType\ExOfficioStrikingOffType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ExOfficioStrikingOffType) {
            throw new \InvalidArgumentException(sprintf('The EnterpriseExOfficioStrikingOff property can only contain items of type \KBO\StructType\ExOfficioStrikingOffType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EnterpriseExOfficioStrikingOff[] = $item;
        return $this;
    }
    /**
     * Get PrimaryDenomination value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getPrimaryDenomination()
    {
        return $this->PrimaryDenomination;
    }
    /**
     * This method is responsible for validating the values passed to the setPrimaryDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrimaryDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypePrimaryDenominationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypePrimaryDenominationItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($establishmentTypePrimaryDenominationItem) ? get_class($establishmentTypePrimaryDenominationItem) : sprintf('%s(%s)', gettype($establishmentTypePrimaryDenominationItem), var_export($establishmentTypePrimaryDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PrimaryDenomination property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $primaryDenomination
     * @return \KBO\StructType\EstablishmentType
     */
    public function setPrimaryDenomination(array $primaryDenomination = array())
    {
        // validation for constraint: array
        if ('' !== ($primaryDenominationArrayErrorMessage = self::validatePrimaryDenominationForArrayConstraintsFromSetPrimaryDenomination($primaryDenomination))) {
            throw new \InvalidArgumentException($primaryDenominationArrayErrorMessage, __LINE__);
        }
        $this->PrimaryDenomination = $primaryDenomination;
        return $this;
    }
    /**
     * Add item to PrimaryDenomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\EstablishmentType
     */
    public function addToPrimaryDenomination(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The PrimaryDenomination property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PrimaryDenomination[] = $item;
        return $this;
    }
    /**
     * Get Denomination value
     * @return \KBO\StructType\DenominationType[]|null
     */
    public function getDenomination()
    {
        return $this->Denomination;
    }
    /**
     * This method is responsible for validating the values passed to the setDenomination method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDenomination method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDenominationForArrayConstraintsFromSetDenomination(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeDenominationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeDenominationItem instanceof \KBO\StructType\DenominationType) {
                $invalidValues[] = is_object($establishmentTypeDenominationItem) ? get_class($establishmentTypeDenominationItem) : sprintf('%s(%s)', gettype($establishmentTypeDenominationItem), var_export($establishmentTypeDenominationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Denomination property can only contain items of type \KBO\StructType\DenominationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Denomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DenominationType[] $denomination
     * @return \KBO\StructType\EstablishmentType
     */
    public function setDenomination(array $denomination = array())
    {
        // validation for constraint: array
        if ('' !== ($denominationArrayErrorMessage = self::validateDenominationForArrayConstraintsFromSetDenomination($denomination))) {
            throw new \InvalidArgumentException($denominationArrayErrorMessage, __LINE__);
        }
        $this->Denomination = $denomination;
        return $this;
    }
    /**
     * Add item to Denomination value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DenominationType $item
     * @return \KBO\StructType\EstablishmentType
     */
    public function addToDenomination(\KBO\StructType\DenominationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DenominationType) {
            throw new \InvalidArgumentException(sprintf('The Denomination property can only contain items of type \KBO\StructType\DenominationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Denomination[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \KBO\StructType\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \KBO\StructType\AddressType $address
     * @return \KBO\StructType\EstablishmentType
     */
    public function setAddress(\KBO\StructType\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get ContactInformation value
     * @return \KBO\StructType\ContactInformationType[]|null
     */
    public function getContactInformation()
    {
        return $this->ContactInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInformationForArrayConstraintsFromSetContactInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeContactInformationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeContactInformationItem instanceof \KBO\StructType\ContactInformationType) {
                $invalidValues[] = is_object($establishmentTypeContactInformationItem) ? get_class($establishmentTypeContactInformationItem) : sprintf('%s(%s)', gettype($establishmentTypeContactInformationItem), var_export($establishmentTypeContactInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInformation property can only contain items of type \KBO\StructType\ContactInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInformation value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ContactInformationType[] $contactInformation
     * @return \KBO\StructType\EstablishmentType
     */
    public function setContactInformation(array $contactInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInformationArrayErrorMessage = self::validateContactInformationForArrayConstraintsFromSetContactInformation($contactInformation))) {
            throw new \InvalidArgumentException($contactInformationArrayErrorMessage, __LINE__);
        }
        $this->ContactInformation = $contactInformation;
        return $this;
    }
    /**
     * Add item to ContactInformation value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ContactInformationType $item
     * @return \KBO\StructType\EstablishmentType
     */
    public function addToContactInformation(\KBO\StructType\ContactInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ContactInformationType) {
            throw new \InvalidArgumentException(sprintf('The ContactInformation property can only contain items of type \KBO\StructType\ContactInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInformation[] = $item;
        return $this;
    }
    /**
     * Get Authorization value
     * @return \KBO\StructType\AuthorizationType[]|null
     */
    public function getAuthorization()
    {
        return $this->Authorization;
    }
    /**
     * This method is responsible for validating the values passed to the setAuthorization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuthorization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuthorizationForArrayConstraintsFromSetAuthorization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeAuthorizationItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeAuthorizationItem instanceof \KBO\StructType\AuthorizationType) {
                $invalidValues[] = is_object($establishmentTypeAuthorizationItem) ? get_class($establishmentTypeAuthorizationItem) : sprintf('%s(%s)', gettype($establishmentTypeAuthorizationItem), var_export($establishmentTypeAuthorizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Authorization property can only contain items of type \KBO\StructType\AuthorizationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Authorization value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\AuthorizationType[] $authorization
     * @return \KBO\StructType\EstablishmentType
     */
    public function setAuthorization(array $authorization = array())
    {
        // validation for constraint: array
        if ('' !== ($authorizationArrayErrorMessage = self::validateAuthorizationForArrayConstraintsFromSetAuthorization($authorization))) {
            throw new \InvalidArgumentException($authorizationArrayErrorMessage, __LINE__);
        }
        $this->Authorization = $authorization;
        return $this;
    }
    /**
     * Add item to Authorization value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\AuthorizationType $item
     * @return \KBO\StructType\EstablishmentType
     */
    public function addToAuthorization(\KBO\StructType\AuthorizationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\AuthorizationType) {
            throw new \InvalidArgumentException(sprintf('The Authorization property can only contain items of type \KBO\StructType\AuthorizationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Authorization[] = $item;
        return $this;
    }
    /**
     * Get Activity value
     * @return \KBO\StructType\ActivityType[]|null
     */
    public function getActivity()
    {
        return $this->Activity;
    }
    /**
     * This method is responsible for validating the values passed to the setActivity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setActivity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActivityForArrayConstraintsFromSetActivity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $establishmentTypeActivityItem) {
            // validation for constraint: itemType
            if (!$establishmentTypeActivityItem instanceof \KBO\StructType\ActivityType) {
                $invalidValues[] = is_object($establishmentTypeActivityItem) ? get_class($establishmentTypeActivityItem) : sprintf('%s(%s)', gettype($establishmentTypeActivityItem), var_export($establishmentTypeActivityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Activity property can only contain items of type \KBO\StructType\ActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Activity value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ActivityType[] $activity
     * @return \KBO\StructType\EstablishmentType
     */
    public function setActivity(array $activity = array())
    {
        // validation for constraint: array
        if ('' !== ($activityArrayErrorMessage = self::validateActivityForArrayConstraintsFromSetActivity($activity))) {
            throw new \InvalidArgumentException($activityArrayErrorMessage, __LINE__);
        }
        $this->Activity = $activity;
        return $this;
    }
    /**
     * Add item to Activity value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\ActivityType $item
     * @return \KBO\StructType\EstablishmentType
     */
    public function addToActivity(\KBO\StructType\ActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\ActivityType) {
            throw new \InvalidArgumentException(sprintf('The Activity property can only contain items of type \KBO\StructType\ActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Activity[] = $item;
        return $this;
    }
}
