<?php

namespace KBO;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'EnterpriseType' => '\\KBO\\StructType\\EnterpriseType',
            'EstablishmentType' => '\\KBO\\StructType\\EstablishmentType',
            'TypeOfAddressType' => '\\KBO\\StructType\\TypeOfAddressType',
            'NaturalPersonFounderType' => '\\KBO\\StructType\\NaturalPersonFounderType',
            'JuridicalSituationType' => '\\KBO\\StructType\\JuridicalSituationType',
            'EventType' => '\\KBO\\StructType\\EventType',
            'JuridicalFormType' => '\\KBO\\StructType\\JuridicalFormType',
            'JuridicalFormCACType' => '\\KBO\\StructType\\JuridicalFormCACType',
            'DenominationType' => '\\KBO\\StructType\\DenominationType',
            'DescriptionType' => '\\KBO\\StructType\\DescriptionType',
            'PeriodType' => '\\KBO\\StructType\\PeriodType',
            'AddressType' => '\\KBO\\StructType\\AddressType',
            'StreetType' => '\\KBO\\StructType\\StreetType',
            'MunicipalityType' => '\\KBO\\StructType\\MunicipalityType',
            'CountryType' => '\\KBO\\StructType\\CountryType',
            'CbeTechnicalType' => '\\KBO\\StructType\\CbeTechnicalType',
            'AuthorizationType' => '\\KBO\\StructType\\AuthorizationType',
            'ActivityType' => '\\KBO\\StructType\\ActivityType',
            'FunctionType' => '\\KBO\\StructType\\FunctionType',
            'FunctionCACType' => '\\KBO\\StructType\\FunctionCACType',
            'LinkedEnterpriseType' => '\\KBO\\StructType\\LinkedEnterpriseType',
            'FinancialDataType' => '\\KBO\\StructType\\FinancialDataType',
            'ProfessionalCompetenceType' => '\\KBO\\StructType\\ProfessionalCompetenceType',
            'ExemptionType' => '\\KBO\\StructType\\ExemptionType',
            'PersonType' => '\\KBO\\StructType\\PersonType',
            'QualificationType' => '\\KBO\\StructType\\QualificationType',
            'ActivityClassificationType' => '\\KBO\\StructType\\ActivityClassificationType',
            'ActivityGroupAdministrationType' => '\\KBO\\StructType\\ActivityGroupAdministrationType',
            'StatusType' => '\\KBO\\StructType\\StatusType',
            'CapitalType' => '\\KBO\\StructType\\CapitalType',
            'ReplacementType' => '\\KBO\\StructType\\ReplacementType',
            'ExOfficioStrikingOffType' => '\\KBO\\StructType\\ExOfficioStrikingOffType',
            'ContactInformationType' => '\\KBO\\StructType\\ContactInformationType',
            'BranchType' => '\\KBO\\StructType\\BranchType',
            'ReadEnterpriseRequestType' => '\\KBO\\StructType\\ReadEnterpriseRequestType',
            'ReadEnterpriseReplyType' => '\\KBO\\StructType\\ReadEnterpriseReplyType',
            'ReadEstablishmentByEnterpriseNumberRequestType' => '\\KBO\\StructType\\ReadEstablishmentByEnterpriseNumberRequestType',
            'ReadEstablishmentByEnterpriseNumberReplyType' => '\\KBO\\StructType\\ReadEstablishmentByEnterpriseNumberReplyType',
            'ReadEstablishmentByEstablishmentNumberRequestType' => '\\KBO\\StructType\\ReadEstablishmentByEstablishmentNumberRequestType',
            'ReadEstablishmentByEstablishmentNumberReplyType' => '\\KBO\\StructType\\ReadEstablishmentByEstablishmentNumberReplyType',
            'ReadEnterpriseByPhonemeRequestType' => '\\KBO\\StructType\\ReadEnterpriseByPhonemeRequestType',
            'ReadEnterpriseByPhonemeReplyType' => '\\KBO\\StructType\\ReadEnterpriseByPhonemeReplyType',
            'ReadEnterpriseByPhysicalPersonNameExactMatchRequestType' => '\\KBO\\StructType\\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType',
            'ReadEnterpriseByPhysicalPersonNameExactMatchReplyType' => '\\KBO\\StructType\\ReadEnterpriseByPhysicalPersonNameExactMatchReplyType',
            'ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType' => '\\KBO\\StructType\\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType',
            'ReadEnterpriseLegalPersonByCompanyNameExactMatchReplyType' => '\\KBO\\StructType\\ReadEnterpriseLegalPersonByCompanyNameExactMatchReplyType',
            'ReadEstablishmentByNameExactMatchRequestType' => '\\KBO\\StructType\\ReadEstablishmentByNameExactMatchRequestType',
            'ReadEstablishmentByNameExactMatchReplyType' => '\\KBO\\StructType\\ReadEstablishmentByNameExactMatchReplyType',
            'ReadEstablishmentByPhonemeRequestType' => '\\KBO\\StructType\\ReadEstablishmentByPhonemeRequestType',
            'ReadEstablishmentByPhonemeReplyType' => '\\KBO\\StructType\\ReadEstablishmentByPhonemeReplyType',
            'ReadEnterpriseOrEstablishmentByAddressRequestType' => '\\KBO\\StructType\\ReadEnterpriseOrEstablishmentByAddressRequestType',
            'ReadEnterpriseOrEstablishmentByAddressReplyType' => '\\KBO\\StructType\\ReadEnterpriseOrEstablishmentByAddressReplyType',
            'ReadStreetNameRequestType' => '\\KBO\\StructType\\ReadStreetNameRequestType',
            'ReadStreetNameReplyType' => '\\KBO\\StructType\\ReadStreetNameReplyType',
            'MunicipalityLocationFilterType' => '\\KBO\\StructType\\MunicipalityLocationFilterType',
            'NeighboringMunicipalityLocationFilterType' => '\\KBO\\StructType\\NeighboringMunicipalityLocationFilterType',
            'ZipcodeLocationFilterType' => '\\KBO\\StructType\\ZipcodeLocationFilterType',
            'LocationFilterType' => '\\KBO\\StructType\\LocationFilterType',
            'ActivityFilterType' => '\\KBO\\StructType\\ActivityFilterType',
            'ReadEnterpriseOrEstablishmentByActivityRequestType' => '\\KBO\\StructType\\ReadEnterpriseOrEstablishmentByActivityRequestType',
            'ReadEnterpriseOrEstablishmentByActivityReplyType' => '\\KBO\\StructType\\ReadEnterpriseOrEstablishmentByActivityReplyType',
            'ReadEnterpriseByAuthorizationRequestType' => '\\KBO\\StructType\\ReadEnterpriseByAuthorizationRequestType',
            'ReadEnterpriseByAuthorizationReplyType' => '\\KBO\\StructType\\ReadEnterpriseByAuthorizationReplyType',
            'ReadEstablishmentByAuthorizationRequestType' => '\\KBO\\StructType\\ReadEstablishmentByAuthorizationRequestType',
            'ReadEstablishmentByAuthorizationReplyType' => '\\KBO\\StructType\\ReadEstablishmentByAuthorizationReplyType',
            'KeyValuePairType' => '\\KBO\\StructType\\KeyValuePairType',
            'CodeListItemType' => '\\KBO\\StructType\\CodeListItemType',
            'ReadCodeListRequestType' => '\\KBO\\StructType\\ReadCodeListRequestType',
            'ReadCodeListReplyType' => '\\KBO\\StructType\\ReadCodeListReplyType',
            'ReplyStatusType' => '\\KBO\\StructType\\ReplyStatusType',
            'RequestContextType' => '\\KBO\\StructType\\RequestContextType',
            'ReplyContextType' => '\\KBO\\StructType\\ReplyContextType',
        );
    }
}
