<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The Street
     * @var \KBO\StructType\StreetType
     */
    public $Street;
    /**
     * The HouseNumber
     * @var string
     */
    public $HouseNumber;
    /**
     * The Box
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Box;
    /**
     * The Zipcode
     * @var string
     */
    public $Zipcode;
    /**
     * The Municipality
     * @var \KBO\StructType\MunicipalityType
     */
    public $Municipality;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\CountryType
     */
    public $Country;
    /**
     * The ExtraAddressInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExtraAddressInfo;
    /**
     * The Begin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Begin;
    /**
     * The TypeOfAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\TypeOfAddressType
     */
    public $TypeOfAddress;
    /**
     * The TechnicalCreationReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\CbeTechnicalType
     */
    public $TechnicalCreationReason;
    /**
     * The Removed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Removed;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setStreet()
     * @uses AddressType::setHouseNumber()
     * @uses AddressType::setBox()
     * @uses AddressType::setZipcode()
     * @uses AddressType::setMunicipality()
     * @uses AddressType::setCountry()
     * @uses AddressType::setExtraAddressInfo()
     * @uses AddressType::setBegin()
     * @uses AddressType::setTypeOfAddress()
     * @uses AddressType::setTechnicalCreationReason()
     * @uses AddressType::setRemoved()
     * @param \KBO\StructType\StreetType $street
     * @param string $houseNumber
     * @param string $box
     * @param string $zipcode
     * @param \KBO\StructType\MunicipalityType $municipality
     * @param \KBO\StructType\CountryType $country
     * @param string $extraAddressInfo
     * @param string $begin
     * @param \KBO\StructType\TypeOfAddressType $typeOfAddress
     * @param \KBO\StructType\CbeTechnicalType $technicalCreationReason
     * @param string $removed
     */
    public function __construct(\KBO\StructType\StreetType $street = null, $houseNumber = null, $box = null, $zipcode = null, \KBO\StructType\MunicipalityType $municipality = null, \KBO\StructType\CountryType $country = null, $extraAddressInfo = null, $begin = null, \KBO\StructType\TypeOfAddressType $typeOfAddress = null, \KBO\StructType\CbeTechnicalType $technicalCreationReason = null, $removed = null)
    {
        $this
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setBox($box)
            ->setZipcode($zipcode)
            ->setMunicipality($municipality)
            ->setCountry($country)
            ->setExtraAddressInfo($extraAddressInfo)
            ->setBegin($begin)
            ->setTypeOfAddress($typeOfAddress)
            ->setTechnicalCreationReason($technicalCreationReason)
            ->setRemoved($removed);
    }
    /**
     * Get Street value
     * @return \KBO\StructType\StreetType|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param \KBO\StructType\StreetType $street
     * @return \KBO\StructType\AddressType
     */
    public function setStreet(\KBO\StructType\StreetType $street = null)
    {
        $this->Street = $street;
        return $this;
    }
    /**
     * Get HouseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }
    /**
     * Set HouseNumber value
     * @param string $houseNumber
     * @return \KBO\StructType\AddressType
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->HouseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get Box value
     * @return string|null
     */
    public function getBox()
    {
        return $this->Box;
    }
    /**
     * Set Box value
     * @param string $box
     * @return \KBO\StructType\AddressType
     */
    public function setBox($box = null)
    {
        // validation for constraint: string
        if (!is_null($box) && !is_string($box)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($box, true), gettype($box)), __LINE__);
        }
        $this->Box = $box;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \KBO\StructType\AddressType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get Municipality value
     * @return \KBO\StructType\MunicipalityType|null
     */
    public function getMunicipality()
    {
        return $this->Municipality;
    }
    /**
     * Set Municipality value
     * @param \KBO\StructType\MunicipalityType $municipality
     * @return \KBO\StructType\AddressType
     */
    public function setMunicipality(\KBO\StructType\MunicipalityType $municipality = null)
    {
        $this->Municipality = $municipality;
        return $this;
    }
    /**
     * Get Country value
     * @return \KBO\StructType\CountryType|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param \KBO\StructType\CountryType $country
     * @return \KBO\StructType\AddressType
     */
    public function setCountry(\KBO\StructType\CountryType $country = null)
    {
        $this->Country = $country;
        return $this;
    }
    /**
     * Get ExtraAddressInfo value
     * @return string|null
     */
    public function getExtraAddressInfo()
    {
        return $this->ExtraAddressInfo;
    }
    /**
     * Set ExtraAddressInfo value
     * @param string $extraAddressInfo
     * @return \KBO\StructType\AddressType
     */
    public function setExtraAddressInfo($extraAddressInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraAddressInfo) && !is_string($extraAddressInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraAddressInfo, true), gettype($extraAddressInfo)), __LINE__);
        }
        $this->ExtraAddressInfo = $extraAddressInfo;
        return $this;
    }
    /**
     * Get Begin value
     * @return string|null
     */
    public function getBegin()
    {
        return $this->Begin;
    }
    /**
     * Set Begin value
     * @param string $begin
     * @return \KBO\StructType\AddressType
     */
    public function setBegin($begin = null)
    {
        // validation for constraint: string
        if (!is_null($begin) && !is_string($begin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($begin, true), gettype($begin)), __LINE__);
        }
        $this->Begin = $begin;
        return $this;
    }
    /**
     * Get TypeOfAddress value
     * @return \KBO\StructType\TypeOfAddressType|null
     */
    public function getTypeOfAddress()
    {
        return $this->TypeOfAddress;
    }
    /**
     * Set TypeOfAddress value
     * @param \KBO\StructType\TypeOfAddressType $typeOfAddress
     * @return \KBO\StructType\AddressType
     */
    public function setTypeOfAddress(\KBO\StructType\TypeOfAddressType $typeOfAddress = null)
    {
        $this->TypeOfAddress = $typeOfAddress;
        return $this;
    }
    /**
     * Get TechnicalCreationReason value
     * @return \KBO\StructType\CbeTechnicalType|null
     */
    public function getTechnicalCreationReason()
    {
        return $this->TechnicalCreationReason;
    }
    /**
     * Set TechnicalCreationReason value
     * @param \KBO\StructType\CbeTechnicalType $technicalCreationReason
     * @return \KBO\StructType\AddressType
     */
    public function setTechnicalCreationReason(\KBO\StructType\CbeTechnicalType $technicalCreationReason = null)
    {
        $this->TechnicalCreationReason = $technicalCreationReason;
        return $this;
    }
    /**
     * Get Removed value
     * @return string|null
     */
    public function getRemoved()
    {
        return $this->Removed;
    }
    /**
     * Set Removed value
     * @param string $removed
     * @return \KBO\StructType\AddressType
     */
    public function setRemoved($removed = null)
    {
        // validation for constraint: string
        if (!is_null($removed) && !is_string($removed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($removed, true), gettype($removed)), __LINE__);
        }
        $this->Removed = $removed;
        return $this;
    }
}
