<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEnterpriseOrEstablishmentByActivityReplyType
 * StructType
 * @subpackage Structs
 */
class ReadEnterpriseOrEstablishmentByActivityReplyType extends AbstractStructBase
{
    /**
     * The Enterprise
     * Meta information extracted from the WSDL
     * - choice: Enterprise | Establishment
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - ref: datamodel:Enterprise
     * @var \KBO\StructType\EnterpriseType
     */
    public $Enterprise;
    /**
     * The Establishment
     * Meta information extracted from the WSDL
     * - choice: Enterprise | Establishment
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - ref: datamodel:Establishment
     * @var \KBO\StructType\EstablishmentType
     */
    public $Establishment;
    /**
     * Constructor method for ReadEnterpriseOrEstablishmentByActivityReplyType
     * @uses ReadEnterpriseOrEstablishmentByActivityReplyType::setEnterprise()
     * @uses ReadEnterpriseOrEstablishmentByActivityReplyType::setEstablishment()
     * @param \KBO\StructType\EnterpriseType $enterprise
     * @param \KBO\StructType\EstablishmentType $establishment
     */
    public function __construct(\KBO\StructType\EnterpriseType $enterprise = null, \KBO\StructType\EstablishmentType $establishment = null)
    {
        $this
            ->setEnterprise($enterprise)
            ->setEstablishment($establishment);
    }
    /**
     * Get Enterprise value
     * @return \KBO\StructType\EnterpriseType|null
     */
    public function getEnterprise()
    {
        return isset($this->Enterprise) ? $this->Enterprise : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEnterprise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnterprise method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEnterpriseForChoiceConstraintsFromSetEnterprise($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Establishment',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Enterprise can\'t be set as the property %s is already set. Only one property must be set among these properties: Enterprise, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Enterprise value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\EnterpriseType $enterprise
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityReplyType
     */
    public function setEnterprise(\KBO\StructType\EnterpriseType $enterprise = null)
    {
        // validation for constraint: choice(Enterprise, Establishment)
        if ('' !== ($enterpriseChoiceErrorMessage = self::validateEnterpriseForChoiceConstraintsFromSetEnterprise($enterprise))) {
            throw new \InvalidArgumentException($enterpriseChoiceErrorMessage, __LINE__);
        }
        if (is_null($enterprise) || (is_array($enterprise) && empty($enterprise))) {
            unset($this->Enterprise);
        } else {
            $this->Enterprise = $enterprise;
        }
        return $this;
    }
    /**
     * Get Establishment value
     * @return \KBO\StructType\EstablishmentType|null
     */
    public function getEstablishment()
    {
        return isset($this->Establishment) ? $this->Establishment : null;
    }
    /**
     * This method is responsible for validating the value passed to the setEstablishment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstablishment method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateEstablishmentForChoiceConstraintsFromSetEstablishment($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Enterprise',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Establishment can\'t be set as the property %s is already set. Only one property must be set among these properties: Establishment, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Establishment value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\EstablishmentType $establishment
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityReplyType
     */
    public function setEstablishment(\KBO\StructType\EstablishmentType $establishment = null)
    {
        // validation for constraint: choice(Enterprise, Establishment)
        if ('' !== ($establishmentChoiceErrorMessage = self::validateEstablishmentForChoiceConstraintsFromSetEstablishment($establishment))) {
            throw new \InvalidArgumentException($establishmentChoiceErrorMessage, __LINE__);
        }
        if (is_null($establishment) || (is_array($establishment) && empty($establishment))) {
            unset($this->Establishment);
        } else {
            $this->Establishment = $establishment;
        }
        return $this;
    }
}
