<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEnterpriseByPhonemeRequestType StructType
 * @subpackage Structs
 */
class ReadEnterpriseByPhonemeRequestType extends AbstractStructBase
{
    /**
     * The Phoneme
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 160
     * - maxOccurs: 10
     * - minLength: 1
     * - pattern: .+
     * @var string[]
     */
    public $Phoneme;
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - minOccurs: 0
     * - pattern: \d{4}
     * @var string
     */
    public $Zipcode;
    /**
     * The TypeOfEnterprise
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var string[]
     */
    public $TypeOfEnterprise;
    /**
     * The EnterpriseJuridicalForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\JuridicalFormType
     */
    public $EnterpriseJuridicalForm;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for ReadEnterpriseByPhonemeRequestType
     * @uses ReadEnterpriseByPhonemeRequestType::setPhoneme()
     * @uses ReadEnterpriseByPhonemeRequestType::setZipcode()
     * @uses ReadEnterpriseByPhonemeRequestType::setTypeOfEnterprise()
     * @uses ReadEnterpriseByPhonemeRequestType::setEnterpriseJuridicalForm()
     * @uses ReadEnterpriseByPhonemeRequestType::setActiveFilter()
     * @param string[] $phoneme
     * @param string $zipcode
     * @param string[] $typeOfEnterprise
     * @param \KBO\StructType\JuridicalFormType $enterpriseJuridicalForm
     * @param bool $activeFilter
     */
    public function __construct(array $phoneme = array(), $zipcode = null, array $typeOfEnterprise = array(), \KBO\StructType\JuridicalFormType $enterpriseJuridicalForm = null, $activeFilter = null)
    {
        $this
            ->setPhoneme($phoneme)
            ->setZipcode($zipcode)
            ->setTypeOfEnterprise($typeOfEnterprise)
            ->setEnterpriseJuridicalForm($enterpriseJuridicalForm)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get Phoneme value
     * @return string[]|null
     */
    public function getPhoneme()
    {
        return $this->Phoneme;
    }
    /**
     * This method is responsible for validating the values passed to the setPhoneme method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneme method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhonemeForArrayConstraintsFromSetPhoneme(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readEnterpriseByPhonemeRequestTypePhonemeItem) {
            // validation for constraint: itemType
            if (!is_string($readEnterpriseByPhonemeRequestTypePhonemeItem)) {
                $invalidValues[] = is_object($readEnterpriseByPhonemeRequestTypePhonemeItem) ? get_class($readEnterpriseByPhonemeRequestTypePhonemeItem) : sprintf('%s(%s)', gettype($readEnterpriseByPhonemeRequestTypePhonemeItem), var_export($readEnterpriseByPhonemeRequestTypePhonemeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Phoneme property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPhoneme method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneme method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhonemeForMaxLengthConstraintFromSetPhoneme($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readEnterpriseByPhonemeRequestTypePhonemeItem) {
            // validation for constraint: maxLength(160)
            if (mb_strlen($readEnterpriseByPhonemeRequestTypePhonemeItem) > 160) {
                $invalidValues[] = var_export($readEnterpriseByPhonemeRequestTypePhonemeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 160', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPhoneme method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhoneme method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhonemeForMinLengthConstraintFromSetPhoneme($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readEnterpriseByPhonemeRequestTypePhonemeItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($readEnterpriseByPhonemeRequestTypePhonemeItem) < 1) {
                $invalidValues[] = var_export($readEnterpriseByPhonemeRequestTypePhonemeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Phoneme value
     * @throws \InvalidArgumentException
     * @param string[] $phoneme
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function setPhoneme(array $phoneme = array())
    {
        // validation for constraint: array
        if ('' !== ($phonemeArrayErrorMessage = self::validatePhonemeForArrayConstraintsFromSetPhoneme($phoneme))) {
            throw new \InvalidArgumentException($phonemeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(160)
        if ('' !== ($phonemeMaxLengthErrorMessage = self::validatePhonemeForMaxLengthConstraintFromSetPhoneme($phoneme))) {
            throw new \InvalidArgumentException($phonemeMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($phoneme) && count($phoneme) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($phoneme)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($phonemeMinLengthErrorMessage = self::validatePhonemeForMinLengthConstraintFromSetPhoneme($phoneme))) {
            throw new \InvalidArgumentException($phonemeMinLengthErrorMessage, __LINE__);
        }
        // validation for constraint: pattern(.+)
        if (!is_null($phoneme) && !preg_match('/.+/', $phoneme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression .+', var_export($phoneme, true)), __LINE__);
        }
        $this->Phoneme = $phoneme;
        return $this;
    }
    /**
     * Add item to Phoneme value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function addToPhoneme($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Phoneme property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(160)
        if (mb_strlen($item) > 160) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 160', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Phoneme) && count($this->Phoneme) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Phoneme)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: pattern(.+)
        if (!preg_match('/.+/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression .+', var_export($item, true)), __LINE__);
        }
        $this->Phoneme[] = $item;
        return $this;
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get TypeOfEnterprise value
     * @return string[]|null
     */
    public function getTypeOfEnterprise()
    {
        return $this->TypeOfEnterprise;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeOfEnterprise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeOfEnterprise method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeOfEnterpriseForArrayConstraintsFromSetTypeOfEnterprise(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readEnterpriseByPhonemeRequestTypeTypeOfEnterpriseItem) {
            // validation for constraint: enumeration
            if (!\KBO\EnumType\Type::valueIsValid($readEnterpriseByPhonemeRequestTypeTypeOfEnterpriseItem)) {
                $invalidValues[] = is_object($readEnterpriseByPhonemeRequestTypeTypeOfEnterpriseItem) ? get_class($readEnterpriseByPhonemeRequestTypeTypeOfEnterpriseItem) : sprintf('%s(%s)', gettype($readEnterpriseByPhonemeRequestTypeTypeOfEnterpriseItem), var_export($readEnterpriseByPhonemeRequestTypeTypeOfEnterpriseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \KBO\EnumType\Type', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \KBO\EnumType\Type::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeOfEnterprise value
     * @uses \KBO\EnumType\Type::valueIsValid()
     * @uses \KBO\EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typeOfEnterprise
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function setTypeOfEnterprise(array $typeOfEnterprise = array())
    {
        // validation for constraint: array
        if ('' !== ($typeOfEnterpriseArrayErrorMessage = self::validateTypeOfEnterpriseForArrayConstraintsFromSetTypeOfEnterprise($typeOfEnterprise))) {
            throw new \InvalidArgumentException($typeOfEnterpriseArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($typeOfEnterprise) && count($typeOfEnterprise) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($typeOfEnterprise)), __LINE__);
        }
        $this->TypeOfEnterprise = $typeOfEnterprise;
        return $this;
    }
    /**
     * Add item to TypeOfEnterprise value
     * @uses \KBO\EnumType\Type::valueIsValid()
     * @uses \KBO\EnumType\Type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function addToTypeOfEnterprise($item)
    {
        // validation for constraint: enumeration
        if (!\KBO\EnumType\Type::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \KBO\EnumType\Type', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \KBO\EnumType\Type::getValidValues())), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->TypeOfEnterprise) && count($this->TypeOfEnterprise) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->TypeOfEnterprise)), __LINE__);
        }
        $this->TypeOfEnterprise[] = $item;
        return $this;
    }
    /**
     * Get EnterpriseJuridicalForm value
     * @return \KBO\StructType\JuridicalFormType|null
     */
    public function getEnterpriseJuridicalForm()
    {
        return $this->EnterpriseJuridicalForm;
    }
    /**
     * Set EnterpriseJuridicalForm value
     * @param \KBO\StructType\JuridicalFormType $enterpriseJuridicalForm
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function setEnterpriseJuridicalForm(\KBO\StructType\JuridicalFormType $enterpriseJuridicalForm = null)
    {
        $this->EnterpriseJuridicalForm = $enterpriseJuridicalForm;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \KBO\StructType\ReadEnterpriseByPhonemeRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
