<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadEnterpriseByAuthorizationRequestType StructType
 * @subpackage Structs
 */
class ReadEnterpriseByAuthorizationRequestType extends AbstractStructBase
{
    /**
     * The AuthorizationFilter
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * @var string
     */
    public $AuthorizationFilter;
    /**
     * The LocationFilter
     * @var \KBO\StructType\LocationFilterType
     */
    public $LocationFilter;
    /**
     * The ActiveFilter
     * @var bool
     */
    public $ActiveFilter;
    /**
     * Constructor method for ReadEnterpriseByAuthorizationRequestType
     * @uses ReadEnterpriseByAuthorizationRequestType::setAuthorizationFilter()
     * @uses ReadEnterpriseByAuthorizationRequestType::setLocationFilter()
     * @uses ReadEnterpriseByAuthorizationRequestType::setActiveFilter()
     * @param string $authorizationFilter
     * @param \KBO\StructType\LocationFilterType $locationFilter
     * @param bool $activeFilter
     */
    public function __construct($authorizationFilter = null, \KBO\StructType\LocationFilterType $locationFilter = null, $activeFilter = null)
    {
        $this
            ->setAuthorizationFilter($authorizationFilter)
            ->setLocationFilter($locationFilter)
            ->setActiveFilter($activeFilter);
    }
    /**
     * Get AuthorizationFilter value
     * @return string|null
     */
    public function getAuthorizationFilter()
    {
        return $this->AuthorizationFilter;
    }
    /**
     * Set AuthorizationFilter value
     * @param string $authorizationFilter
     * @return \KBO\StructType\ReadEnterpriseByAuthorizationRequestType
     */
    public function setAuthorizationFilter($authorizationFilter = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationFilter) && !is_string($authorizationFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationFilter, true), gettype($authorizationFilter)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($authorizationFilter) && mb_strlen($authorizationFilter) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($authorizationFilter)), __LINE__);
        }
        $this->AuthorizationFilter = $authorizationFilter;
        return $this;
    }
    /**
     * Get LocationFilter value
     * @return \KBO\StructType\LocationFilterType|null
     */
    public function getLocationFilter()
    {
        return $this->LocationFilter;
    }
    /**
     * Set LocationFilter value
     * @param \KBO\StructType\LocationFilterType $locationFilter
     * @return \KBO\StructType\ReadEnterpriseByAuthorizationRequestType
     */
    public function setLocationFilter(\KBO\StructType\LocationFilterType $locationFilter = null)
    {
        $this->LocationFilter = $locationFilter;
        return $this;
    }
    /**
     * Get ActiveFilter value
     * @return bool|null
     */
    public function getActiveFilter()
    {
        return $this->ActiveFilter;
    }
    /**
     * Set ActiveFilter value
     * @param bool $activeFilter
     * @return \KBO\StructType\ReadEnterpriseByAuthorizationRequestType
     */
    public function setActiveFilter($activeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeFilter) && !is_bool($activeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeFilter, true), gettype($activeFilter)), __LINE__);
        }
        $this->ActiveFilter = $activeFilter;
        return $this;
    }
}
