<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadStreetNameRequestType StructType
 * @subpackage Structs
 */
class ReadStreetNameRequestType extends AbstractStructBase
{
    /**
     * The Zipcode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - length: 4
     * - pattern: \d{4}
     * @var string
     */
    public $Zipcode;
    /**
     * The PartOfStreetName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 2
     * @var string
     */
    public $PartOfStreetName;
    /**
     * Constructor method for ReadStreetNameRequestType
     * @uses ReadStreetNameRequestType::setZipcode()
     * @uses ReadStreetNameRequestType::setPartOfStreetName()
     * @param string $zipcode
     * @param string $partOfStreetName
     */
    public function __construct($zipcode = null, $partOfStreetName = null)
    {
        $this
            ->setZipcode($zipcode)
            ->setPartOfStreetName($partOfStreetName);
    }
    /**
     * Get Zipcode value
     * @return string|null
     */
    public function getZipcode()
    {
        return $this->Zipcode;
    }
    /**
     * Set Zipcode value
     * @param string $zipcode
     * @return \KBO\StructType\ReadStreetNameRequestType
     */
    public function setZipcode($zipcode = null)
    {
        // validation for constraint: string
        if (!is_null($zipcode) && !is_string($zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcode, true), gettype($zipcode)), __LINE__);
        }
        // validation for constraint: length(4)
        if (!is_null($zipcode) && mb_strlen($zipcode) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 4', mb_strlen($zipcode)), __LINE__);
        }
        // validation for constraint: pattern(\d{4})
        if (!is_null($zipcode) && !preg_match('/\\d{4}/', $zipcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d{4}', var_export($zipcode, true)), __LINE__);
        }
        $this->Zipcode = $zipcode;
        return $this;
    }
    /**
     * Get PartOfStreetName value
     * @return string|null
     */
    public function getPartOfStreetName()
    {
        return $this->PartOfStreetName;
    }
    /**
     * Set PartOfStreetName value
     * @param string $partOfStreetName
     * @return \KBO\StructType\ReadStreetNameRequestType
     */
    public function setPartOfStreetName($partOfStreetName = null)
    {
        // validation for constraint: string
        if (!is_null($partOfStreetName) && !is_string($partOfStreetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partOfStreetName, true), gettype($partOfStreetName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($partOfStreetName) && mb_strlen($partOfStreetName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($partOfStreetName)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($partOfStreetName) && mb_strlen($partOfStreetName) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($partOfStreetName)), __LINE__);
        }
        $this->PartOfStreetName = $partOfStreetName;
        return $this;
    }
}
