<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReplacementType StructType
 * @subpackage Structs
 */
class ReplacementType extends AbstractStructBase
{
    /**
     * The EnterpriseNumber
     * @var int
     */
    public $EnterpriseNumber;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * Constructor method for ReplacementType
     * @uses ReplacementType::setEnterpriseNumber()
     * @uses ReplacementType::setPeriod()
     * @param int $enterpriseNumber
     * @param \KBO\StructType\PeriodType $period
     */
    public function __construct($enterpriseNumber = null, \KBO\StructType\PeriodType $period = null)
    {
        $this
            ->setEnterpriseNumber($enterpriseNumber)
            ->setPeriod($period);
    }
    /**
     * Get EnterpriseNumber value
     * @return int|null
     */
    public function getEnterpriseNumber()
    {
        return $this->EnterpriseNumber;
    }
    /**
     * Set EnterpriseNumber value
     * @param int $enterpriseNumber
     * @return \KBO\StructType\ReplacementType
     */
    public function setEnterpriseNumber($enterpriseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumber) && !(is_int($enterpriseNumber) || ctype_digit($enterpriseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumber, true), gettype($enterpriseNumber)), __LINE__);
        }
        $this->EnterpriseNumber = $enterpriseNumber;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\ReplacementType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
}
