<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProfessionalCompetenceType StructType
 * @subpackage Structs
 */
class ProfessionalCompetenceType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \KBO\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * The Exemption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\ExemptionType
     */
    public $Exemption;
    /**
     * Constructor method for ProfessionalCompetenceType
     * @uses ProfessionalCompetenceType::setCode()
     * @uses ProfessionalCompetenceType::setDescription()
     * @uses ProfessionalCompetenceType::setPeriod()
     * @uses ProfessionalCompetenceType::setExemption()
     * @param string $code
     * @param \KBO\StructType\DescriptionType[] $description
     * @param \KBO\StructType\PeriodType $period
     * @param \KBO\StructType\ExemptionType $exemption
     */
    public function __construct($code = null, array $description = array(), \KBO\StructType\PeriodType $period = null, \KBO\StructType\ExemptionType $exemption = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setPeriod($period)
            ->setExemption($exemption);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \KBO\StructType\ProfessionalCompetenceType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $professionalCompetenceTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$professionalCompetenceTypeDescriptionItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($professionalCompetenceTypeDescriptionItem) ? get_class($professionalCompetenceTypeDescriptionItem) : sprintf('%s(%s)', gettype($professionalCompetenceTypeDescriptionItem), var_export($professionalCompetenceTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $description
     * @return \KBO\StructType\ProfessionalCompetenceType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\ProfessionalCompetenceType
     */
    public function addToDescription(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\ProfessionalCompetenceType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Exemption value
     * @return \KBO\StructType\ExemptionType|null
     */
    public function getExemption()
    {
        return $this->Exemption;
    }
    /**
     * Set Exemption value
     * @param \KBO\StructType\ExemptionType $exemption
     * @return \KBO\StructType\ProfessionalCompetenceType
     */
    public function setExemption(\KBO\StructType\ExemptionType $exemption = null)
    {
        $this->Exemption = $exemption;
        return $this;
    }
}
