<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FunctionType StructType
 * @subpackage Structs
 */
class FunctionType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \KBO\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\PersonType
     */
    public $Person;
    /**
     * The EnterpriseNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EnterpriseNumber;
    /**
     * The NaturalPersonFounder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\NaturalPersonFounderType
     */
    public $NaturalPersonFounder;
    /**
     * The FunctionCAC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \KBO\StructType\FunctionCACType
     */
    public $FunctionCAC;
    /**
     * Constructor method for FunctionType
     * @uses FunctionType::setCode()
     * @uses FunctionType::setDescription()
     * @uses FunctionType::setPeriod()
     * @uses FunctionType::setPerson()
     * @uses FunctionType::setEnterpriseNumber()
     * @uses FunctionType::setNaturalPersonFounder()
     * @uses FunctionType::setFunctionCAC()
     * @param string $code
     * @param \KBO\StructType\DescriptionType[] $description
     * @param \KBO\StructType\PeriodType $period
     * @param \KBO\StructType\PersonType $person
     * @param int $enterpriseNumber
     * @param \KBO\StructType\NaturalPersonFounderType $naturalPersonFounder
     * @param \KBO\StructType\FunctionCACType $functionCAC
     */
    public function __construct($code = null, array $description = array(), \KBO\StructType\PeriodType $period = null, \KBO\StructType\PersonType $person = null, $enterpriseNumber = null, \KBO\StructType\NaturalPersonFounderType $naturalPersonFounder = null, \KBO\StructType\FunctionCACType $functionCAC = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setPeriod($period)
            ->setPerson($person)
            ->setEnterpriseNumber($enterpriseNumber)
            ->setNaturalPersonFounder($naturalPersonFounder)
            ->setFunctionCAC($functionCAC);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \KBO\StructType\FunctionType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $functionTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$functionTypeDescriptionItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($functionTypeDescriptionItem) ? get_class($functionTypeDescriptionItem) : sprintf('%s(%s)', gettype($functionTypeDescriptionItem), var_export($functionTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $description
     * @return \KBO\StructType\FunctionType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\FunctionType
     */
    public function addToDescription(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\FunctionType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Person value
     * @return \KBO\StructType\PersonType|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \KBO\StructType\PersonType $person
     * @return \KBO\StructType\FunctionType
     */
    public function setPerson(\KBO\StructType\PersonType $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get EnterpriseNumber value
     * @return int|null
     */
    public function getEnterpriseNumber()
    {
        return $this->EnterpriseNumber;
    }
    /**
     * Set EnterpriseNumber value
     * @param int $enterpriseNumber
     * @return \KBO\StructType\FunctionType
     */
    public function setEnterpriseNumber($enterpriseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($enterpriseNumber) && !(is_int($enterpriseNumber) || ctype_digit($enterpriseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enterpriseNumber, true), gettype($enterpriseNumber)), __LINE__);
        }
        $this->EnterpriseNumber = $enterpriseNumber;
        return $this;
    }
    /**
     * Get NaturalPersonFounder value
     * @return \KBO\StructType\NaturalPersonFounderType|null
     */
    public function getNaturalPersonFounder()
    {
        return $this->NaturalPersonFounder;
    }
    /**
     * Set NaturalPersonFounder value
     * @param \KBO\StructType\NaturalPersonFounderType $naturalPersonFounder
     * @return \KBO\StructType\FunctionType
     */
    public function setNaturalPersonFounder(\KBO\StructType\NaturalPersonFounderType $naturalPersonFounder = null)
    {
        $this->NaturalPersonFounder = $naturalPersonFounder;
        return $this;
    }
    /**
     * Get FunctionCAC value
     * @return \KBO\StructType\FunctionCACType|null
     */
    public function getFunctionCAC()
    {
        return $this->FunctionCAC;
    }
    /**
     * Set FunctionCAC value
     * @param \KBO\StructType\FunctionCACType $functionCAC
     * @return \KBO\StructType\FunctionType
     */
    public function setFunctionCAC(\KBO\StructType\FunctionCACType $functionCAC = null)
    {
        $this->FunctionCAC = $functionCAC;
        return $this;
    }
}
