<?php

namespace KBO\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivityType StructType
 * @subpackage Structs
 */
class ActivityType extends AbstractStructBase
{
    /**
     * The ActivityGroupAdministration
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \KBO\StructType\ActivityGroupAdministrationType
     */
    public $ActivityGroupAdministration;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \KBO\StructType\DescriptionType[]
     */
    public $Description;
    /**
     * The Period
     * @var \KBO\StructType\PeriodType
     */
    public $Period;
    /**
     * The ActivityClassification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \KBO\StructType\ActivityClassificationType
     */
    public $ActivityClassification;
    /**
     * Constructor method for ActivityType
     * @uses ActivityType::setActivityGroupAdministration()
     * @uses ActivityType::setCode()
     * @uses ActivityType::setVersion()
     * @uses ActivityType::setDescription()
     * @uses ActivityType::setPeriod()
     * @uses ActivityType::setActivityClassification()
     * @param \KBO\StructType\ActivityGroupAdministrationType $activityGroupAdministration
     * @param string $code
     * @param string $version
     * @param \KBO\StructType\DescriptionType[] $description
     * @param \KBO\StructType\PeriodType $period
     * @param \KBO\StructType\ActivityClassificationType $activityClassification
     */
    public function __construct(\KBO\StructType\ActivityGroupAdministrationType $activityGroupAdministration = null, $code = null, $version = null, array $description = array(), \KBO\StructType\PeriodType $period = null, \KBO\StructType\ActivityClassificationType $activityClassification = null)
    {
        $this
            ->setActivityGroupAdministration($activityGroupAdministration)
            ->setCode($code)
            ->setVersion($version)
            ->setDescription($description)
            ->setPeriod($period)
            ->setActivityClassification($activityClassification);
    }
    /**
     * Get ActivityGroupAdministration value
     * @return \KBO\StructType\ActivityGroupAdministrationType
     */
    public function getActivityGroupAdministration()
    {
        return $this->ActivityGroupAdministration;
    }
    /**
     * Set ActivityGroupAdministration value
     * @param \KBO\StructType\ActivityGroupAdministrationType $activityGroupAdministration
     * @return \KBO\StructType\ActivityType
     */
    public function setActivityGroupAdministration(\KBO\StructType\ActivityGroupAdministrationType $activityGroupAdministration = null)
    {
        $this->ActivityGroupAdministration = $activityGroupAdministration;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \KBO\StructType\ActivityType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \KBO\StructType\ActivityType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Description value
     * @return \KBO\StructType\DescriptionType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $activityTypeDescriptionItem) {
            // validation for constraint: itemType
            if (!$activityTypeDescriptionItem instanceof \KBO\StructType\DescriptionType) {
                $invalidValues[] = is_object($activityTypeDescriptionItem) ? get_class($activityTypeDescriptionItem) : sprintf('%s(%s)', gettype($activityTypeDescriptionItem), var_export($activityTypeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType[] $description
     * @return \KBO\StructType\ActivityType
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \KBO\StructType\DescriptionType $item
     * @return \KBO\StructType\ActivityType
     */
    public function addToDescription(\KBO\StructType\DescriptionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KBO\StructType\DescriptionType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \KBO\StructType\DescriptionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Period value
     * @return \KBO\StructType\PeriodType|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param \KBO\StructType\PeriodType $period
     * @return \KBO\StructType\ActivityType
     */
    public function setPeriod(\KBO\StructType\PeriodType $period = null)
    {
        $this->Period = $period;
        return $this;
    }
    /**
     * Get ActivityClassification value
     * @return \KBO\StructType\ActivityClassificationType|null
     */
    public function getActivityClassification()
    {
        return $this->ActivityClassification;
    }
    /**
     * Set ActivityClassification value
     * @param \KBO\StructType\ActivityClassificationType $activityClassification
     * @return \KBO\StructType\ActivityType
     */
    public function setActivityClassification(\KBO\StructType\ActivityClassificationType $activityClassification = null)
    {
        $this->ActivityClassification = $activityClassification;
        return $this;
    }
}
