<?php

namespace KBO\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Read ServiceType
 * @subpackage Services
 */
class Read extends AbstractSoapClientBase
{
    /**
     * Sets the RequestContext SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \KBO\StructType\RequestContextType $requestContext
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderRequestContext(\KBO\StructType\RequestContextType $requestContext, $nameSpace = 'http://economie.fgov.be/kbopub/webservices/v1/messages', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'RequestContext', $requestContext, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named ReadEnterprise
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseReplyType|bool
     */
    public function ReadEnterprise(\KBO\StructType\ReadEnterpriseRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterprise($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEnterpriseByPhoneme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseByPhonemeRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseByPhonemeReplyType|bool
     */
    public function ReadEnterpriseByPhoneme(\KBO\StructType\ReadEnterpriseByPhonemeRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseByPhoneme($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEstablishmentByEnterpriseNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEstablishmentByEnterpriseNumberRequestType $requestParameters
     * @return \KBO\StructType\ReadEstablishmentByEnterpriseNumberReplyType|bool
     */
    public function ReadEstablishmentByEnterpriseNumber(\KBO\StructType\ReadEstablishmentByEnterpriseNumberRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByEnterpriseNumber($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEstablishmentByEstablishmentNumber
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEstablishmentByEstablishmentNumberRequestType $requestParameters
     * @return \KBO\StructType\ReadEstablishmentByEstablishmentNumberReplyType|bool
     */
    public function ReadEstablishmentByEstablishmentNumber(\KBO\StructType\ReadEstablishmentByEstablishmentNumberRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByEstablishmentNumber($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseByPhysicalPersonNameExactMatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchReplyType|bool
     */
    public function ReadEnterpriseByPhysicalPersonNameExactMatch(\KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseByPhysicalPersonNameExactMatch($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseLegalPersonByCompanyNameExactMatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchReplyType|bool
     */
    public function ReadEnterpriseLegalPersonByCompanyNameExactMatch(\KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseLegalPersonByCompanyNameExactMatch($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEstablishmentByNameExactMatch
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEstablishmentByNameExactMatchRequestType $requestParameters
     * @return \KBO\StructType\ReadEstablishmentByNameExactMatchReplyType|bool
     */
    public function ReadEstablishmentByNameExactMatch(\KBO\StructType\ReadEstablishmentByNameExactMatchRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByNameExactMatch($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEstablishmentByPhoneme
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEstablishmentByPhonemeRequestType $requestParameters
     * @return \KBO\StructType\ReadEstablishmentByPhonemeReplyType|bool
     */
    public function ReadEstablishmentByPhoneme(\KBO\StructType\ReadEstablishmentByPhonemeRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByPhoneme($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseOrEstablishmentByAddress
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByAddressReplyType|bool
     */
    public function ReadEnterpriseOrEstablishmentByAddress(\KBO\StructType\ReadEnterpriseOrEstablishmentByAddressRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseOrEstablishmentByAddress($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadStreetName
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadStreetNameRequestType $requestParameters
     * @return \KBO\StructType\ReadStreetNameReplyType|bool
     */
    public function ReadStreetName(\KBO\StructType\ReadStreetNameRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadStreetName($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ReadEnterpriseOrEstablishmentByActivity
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseOrEstablishmentByActivityReplyType|bool
     */
    public function ReadEnterpriseOrEstablishmentByActivity(\KBO\StructType\ReadEnterpriseOrEstablishmentByActivityRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseOrEstablishmentByActivity($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEnterpriseByAuthorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEnterpriseByAuthorizationRequestType $requestParameters
     * @return \KBO\StructType\ReadEnterpriseByAuthorizationReplyType|bool
     */
    public function ReadEnterpriseByAuthorization(\KBO\StructType\ReadEnterpriseByAuthorizationRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEnterpriseByAuthorization($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadEstablishmentByAuthorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadEstablishmentByAuthorizationRequestType $requestParameters
     * @return \KBO\StructType\ReadEstablishmentByAuthorizationReplyType|bool
     */
    public function ReadEstablishmentByAuthorization(\KBO\StructType\ReadEstablishmentByAuthorizationRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadEstablishmentByAuthorization($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReadCodeList
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: RequestContext
     * - SOAPHeaderNamespaces: http://economie.fgov.be/kbopub/webservices/v1/messages
     * - SOAPHeaderTypes: \KBO\StructType\RequestContextType
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KBO\StructType\ReadCodeListRequestType $requestParameters
     * @return \KBO\StructType\ReadCodeListReplyType|bool
     */
    public function ReadCodeList(\KBO\StructType\ReadCodeListRequestType $requestParameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReadCodeList($requestParameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KBO\StructType\ReadCodeListReplyType|\KBO\StructType\ReadEnterpriseByAuthorizationReplyType|\KBO\StructType\ReadEnterpriseByPhonemeReplyType|\KBO\StructType\ReadEnterpriseByPhysicalPersonNameExactMatchReplyType|\KBO\StructType\ReadEnterpriseLegalPersonByCompanyNameExactMatchReplyType|\KBO\StructType\ReadEnterpriseOrEstablishmentByActivityReplyType|\KBO\StructType\ReadEnterpriseOrEstablishmentByAddressReplyType|\KBO\StructType\ReadEnterpriseReplyType|\KBO\StructType\ReadEstablishmentByAuthorizationReplyType|\KBO\StructType\ReadEstablishmentByEnterpriseNumberReplyType|\KBO\StructType\ReadEstablishmentByEstablishmentNumberReplyType|\KBO\StructType\ReadEstablishmentByNameExactMatchReplyType|\KBO\StructType\ReadEstablishmentByPhonemeReplyType|\KBO\StructType\ReadStreetNameReplyType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
