<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompositeType EasyStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CompositeType
 * @package Easy
 * @subpackage Structs
 */
class EasyCompositeType extends AbstractStructBase
{
    /**
     * The BoolValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BoolValue;
    /**
     * The StringValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringValue;
    /**
     * Constructor method for CompositeType
     * @uses EasyCompositeType::setBoolValue()
     * @uses EasyCompositeType::setStringValue()
     * @param bool $boolValue
     * @param string $stringValue
     */
    public function __construct($boolValue = null, $stringValue = null)
    {
        $this
            ->setBoolValue($boolValue)
            ->setStringValue($stringValue);
    }
    /**
     * Get BoolValue value
     * @return bool|null
     */
    public function getBoolValue()
    {
        return $this->BoolValue;
    }
    /**
     * Set BoolValue value
     * @param bool $boolValue
     * @return \Easy\EasyStruct\EasyCompositeType
     */
    public function setBoolValue($boolValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($boolValue) && !is_bool($boolValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($boolValue, true), gettype($boolValue)), __LINE__);
        }
        $this->BoolValue = $boolValue;
        return $this;
    }
    /**
     * Get StringValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringValue()
    {
        return isset($this->StringValue) ? $this->StringValue : null;
    }
    /**
     * Set StringValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringValue
     * @return \Easy\EasyStruct\EasyCompositeType
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        if (is_null($stringValue) || (is_array($stringValue) && empty($stringValue))) {
            unset($this->StringValue);
        } else {
            $this->StringValue = $stringValue;
        }
        return $this;
    }
}
