<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClsVoucherCheckpoint EasyStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClsVoucherCheckpoint
 * @package Easy
 * @subpackage Structs
 */
class EasyClsVoucherCheckpoint extends AbstractStructBase
{
    /**
     * The Checkpoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Checkpoint;
    /**
     * The CheckpointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CheckpointDate;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The ShipmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * Constructor method for ClsVoucherCheckpoint
     * @uses EasyClsVoucherCheckpoint::setCheckpoint()
     * @uses EasyClsVoucherCheckpoint::setCheckpointDate()
     * @uses EasyClsVoucherCheckpoint::setCode()
     * @uses EasyClsVoucherCheckpoint::setShipmentNumber()
     * @param string $checkpoint
     * @param string $checkpointDate
     * @param string $code
     * @param float $shipmentNumber
     */
    public function __construct($checkpoint = null, $checkpointDate = null, $code = null, $shipmentNumber = null)
    {
        $this
            ->setCheckpoint($checkpoint)
            ->setCheckpointDate($checkpointDate)
            ->setCode($code)
            ->setShipmentNumber($shipmentNumber);
    }
    /**
     * Get Checkpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckpoint()
    {
        return isset($this->Checkpoint) ? $this->Checkpoint : null;
    }
    /**
     * Set Checkpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkpoint
     * @return \Easy\EasyStruct\EasyClsVoucherCheckpoint
     */
    public function setCheckpoint($checkpoint = null)
    {
        // validation for constraint: string
        if (!is_null($checkpoint) && !is_string($checkpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkpoint, true), gettype($checkpoint)), __LINE__);
        }
        if (is_null($checkpoint) || (is_array($checkpoint) && empty($checkpoint))) {
            unset($this->Checkpoint);
        } else {
            $this->Checkpoint = $checkpoint;
        }
        return $this;
    }
    /**
     * Get CheckpointDate value
     * @return string|null
     */
    public function getCheckpointDate()
    {
        return $this->CheckpointDate;
    }
    /**
     * Set CheckpointDate value
     * @param string $checkpointDate
     * @return \Easy\EasyStruct\EasyClsVoucherCheckpoint
     */
    public function setCheckpointDate($checkpointDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkpointDate) && !is_string($checkpointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkpointDate, true), gettype($checkpointDate)), __LINE__);
        }
        $this->CheckpointDate = $checkpointDate;
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \Easy\EasyStruct\EasyClsVoucherCheckpoint
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \Easy\EasyStruct\EasyClsVoucherCheckpoint
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
}
