<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClsTrackPickUpOrderResp EasyStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClsTrackPickUpOrderResp
 * @package Easy
 * @subpackage Structs
 */
class EasyClsTrackPickUpOrderResp extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The ItemID1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID1;
    /**
     * The ItemID2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID2;
    /**
     * The ItemID3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID3;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The PickUpOrderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickUpOrderID;
    /**
     * The PickUpOrderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PickUpOrderStatus;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Result;
    /**
     * The ShipmentNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyArray\EasyArrayOfdecimal
     */
    public $ShipmentNumbers;
    /**
     * Constructor method for ClsTrackPickUpOrderResp
     * @uses EasyClsTrackPickUpOrderResp::setDateTime()
     * @uses EasyClsTrackPickUpOrderResp::setItemID1()
     * @uses EasyClsTrackPickUpOrderResp::setItemID2()
     * @uses EasyClsTrackPickUpOrderResp::setItemID3()
     * @uses EasyClsTrackPickUpOrderResp::setMessage()
     * @uses EasyClsTrackPickUpOrderResp::setPickUpOrderID()
     * @uses EasyClsTrackPickUpOrderResp::setPickUpOrderStatus()
     * @uses EasyClsTrackPickUpOrderResp::setResult()
     * @uses EasyClsTrackPickUpOrderResp::setShipmentNumbers()
     * @param string $dateTime
     * @param string $itemID1
     * @param string $itemID2
     * @param string $itemID3
     * @param string $message
     * @param int $pickUpOrderID
     * @param string $pickUpOrderStatus
     * @param bool $result
     * @param \Easy\EasyArray\EasyArrayOfdecimal $shipmentNumbers
     */
    public function __construct($dateTime = null, $itemID1 = null, $itemID2 = null, $itemID3 = null, $message = null, $pickUpOrderID = null, $pickUpOrderStatus = null, $result = null, \Easy\EasyArray\EasyArrayOfdecimal $shipmentNumbers = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setItemID1($itemID1)
            ->setItemID2($itemID2)
            ->setItemID3($itemID3)
            ->setMessage($message)
            ->setPickUpOrderID($pickUpOrderID)
            ->setPickUpOrderStatus($pickUpOrderStatus)
            ->setResult($result)
            ->setShipmentNumbers($shipmentNumbers);
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get ItemID1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID1()
    {
        return isset($this->ItemID1) ? $this->ItemID1 : null;
    }
    /**
     * Set ItemID1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID1
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setItemID1($itemID1 = null)
    {
        // validation for constraint: string
        if (!is_null($itemID1) && !is_string($itemID1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID1, true), gettype($itemID1)), __LINE__);
        }
        if (is_null($itemID1) || (is_array($itemID1) && empty($itemID1))) {
            unset($this->ItemID1);
        } else {
            $this->ItemID1 = $itemID1;
        }
        return $this;
    }
    /**
     * Get ItemID2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID2()
    {
        return isset($this->ItemID2) ? $this->ItemID2 : null;
    }
    /**
     * Set ItemID2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID2
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setItemID2($itemID2 = null)
    {
        // validation for constraint: string
        if (!is_null($itemID2) && !is_string($itemID2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID2, true), gettype($itemID2)), __LINE__);
        }
        if (is_null($itemID2) || (is_array($itemID2) && empty($itemID2))) {
            unset($this->ItemID2);
        } else {
            $this->ItemID2 = $itemID2;
        }
        return $this;
    }
    /**
     * Get ItemID3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID3()
    {
        return isset($this->ItemID3) ? $this->ItemID3 : null;
    }
    /**
     * Set ItemID3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID3
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setItemID3($itemID3 = null)
    {
        // validation for constraint: string
        if (!is_null($itemID3) && !is_string($itemID3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID3, true), gettype($itemID3)), __LINE__);
        }
        if (is_null($itemID3) || (is_array($itemID3) && empty($itemID3))) {
            unset($this->ItemID3);
        } else {
            $this->ItemID3 = $itemID3;
        }
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get PickUpOrderID value
     * @return int|null
     */
    public function getPickUpOrderID()
    {
        return $this->PickUpOrderID;
    }
    /**
     * Set PickUpOrderID value
     * @param int $pickUpOrderID
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setPickUpOrderID($pickUpOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($pickUpOrderID) && !(is_int($pickUpOrderID) || ctype_digit($pickUpOrderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickUpOrderID, true), gettype($pickUpOrderID)), __LINE__);
        }
        $this->PickUpOrderID = $pickUpOrderID;
        return $this;
    }
    /**
     * Get PickUpOrderStatus value
     * @return string|null
     */
    public function getPickUpOrderStatus()
    {
        return $this->PickUpOrderStatus;
    }
    /**
     * Set PickUpOrderStatus value
     * @param string $pickUpOrderStatus
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setPickUpOrderStatus($pickUpOrderStatus = null)
    {
        // validation for constraint: string
        if (!is_null($pickUpOrderStatus) && !is_string($pickUpOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickUpOrderStatus, true), gettype($pickUpOrderStatus)), __LINE__);
        }
        $this->PickUpOrderStatus = $pickUpOrderStatus;
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get ShipmentNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyArray\EasyArrayOfdecimal|null
     */
    public function getShipmentNumbers()
    {
        return isset($this->ShipmentNumbers) ? $this->ShipmentNumbers : null;
    }
    /**
     * Set ShipmentNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyArray\EasyArrayOfdecimal $shipmentNumbers
     * @return \Easy\EasyStruct\EasyClsTrackPickUpOrderResp
     */
    public function setShipmentNumbers(\Easy\EasyArray\EasyArrayOfdecimal $shipmentNumbers = null)
    {
        if (is_null($shipmentNumbers) || (is_array($shipmentNumbers) && empty($shipmentNumbers))) {
            unset($this->ShipmentNumbers);
        } else {
            $this->ShipmentNumbers = $shipmentNumbers;
        }
        return $this;
    }
}
