<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClsCustomerCostCenter EasyStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClsCustomerCostCenter
 * @package Easy
 * @subpackage Structs
 */
class EasyClsCustomerCostCenter extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Area;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CustomerID;
    /**
     * The DiscreetName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DiscreetName;
    /**
     * The IsEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEnabled;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ParentCustomerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ParentCustomerID;
    /**
     * The Phone1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone1;
    /**
     * The Phone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone2;
    /**
     * The Phone3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone3;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PostalCode;
    /**
     * Constructor method for ClsCustomerCostCenter
     * @uses EasyClsCustomerCostCenter::setAddress()
     * @uses EasyClsCustomerCostCenter::setArea()
     * @uses EasyClsCustomerCostCenter::setCity()
     * @uses EasyClsCustomerCostCenter::setCustomerID()
     * @uses EasyClsCustomerCostCenter::setDiscreetName()
     * @uses EasyClsCustomerCostCenter::setIsEnabled()
     * @uses EasyClsCustomerCostCenter::setName()
     * @uses EasyClsCustomerCostCenter::setParentCustomerID()
     * @uses EasyClsCustomerCostCenter::setPhone1()
     * @uses EasyClsCustomerCostCenter::setPhone2()
     * @uses EasyClsCustomerCostCenter::setPhone3()
     * @uses EasyClsCustomerCostCenter::setPostalCode()
     * @param string $address
     * @param string $area
     * @param string $city
     * @param int $customerID
     * @param string $discreetName
     * @param bool $isEnabled
     * @param string $name
     * @param int $parentCustomerID
     * @param string $phone1
     * @param string $phone2
     * @param string $phone3
     * @param float $postalCode
     */
    public function __construct($address = null, $area = null, $city = null, $customerID = null, $discreetName = null, $isEnabled = null, $name = null, $parentCustomerID = null, $phone1 = null, $phone2 = null, $phone3 = null, $postalCode = null)
    {
        $this
            ->setAddress($address)
            ->setArea($area)
            ->setCity($city)
            ->setCustomerID($customerID)
            ->setDiscreetName($discreetName)
            ->setIsEnabled($isEnabled)
            ->setName($name)
            ->setParentCustomerID($parentCustomerID)
            ->setPhone1($phone1)
            ->setPhone2($phone2)
            ->setPhone3($phone3)
            ->setPostalCode($postalCode);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setArea($area = null)
    {
        // validation for constraint: string
        if (!is_null($area) && !is_string($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($area, true), gettype($area)), __LINE__);
        }
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $customerID
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get DiscreetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiscreetName()
    {
        return isset($this->DiscreetName) ? $this->DiscreetName : null;
    }
    /**
     * Set DiscreetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $discreetName
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setDiscreetName($discreetName = null)
    {
        // validation for constraint: string
        if (!is_null($discreetName) && !is_string($discreetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discreetName, true), gettype($discreetName)), __LINE__);
        }
        if (is_null($discreetName) || (is_array($discreetName) && empty($discreetName))) {
            unset($this->DiscreetName);
        } else {
            $this->DiscreetName = $discreetName;
        }
        return $this;
    }
    /**
     * Get IsEnabled value
     * @return bool|null
     */
    public function getIsEnabled()
    {
        return $this->IsEnabled;
    }
    /**
     * Set IsEnabled value
     * @param bool $isEnabled
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setIsEnabled($isEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnabled) && !is_bool($isEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnabled, true), gettype($isEnabled)), __LINE__);
        }
        $this->IsEnabled = $isEnabled;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ParentCustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getParentCustomerID()
    {
        return isset($this->ParentCustomerID) ? $this->ParentCustomerID : null;
    }
    /**
     * Set ParentCustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $parentCustomerID
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setParentCustomerID($parentCustomerID = null)
    {
        // validation for constraint: int
        if (!is_null($parentCustomerID) && !(is_int($parentCustomerID) || ctype_digit($parentCustomerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parentCustomerID, true), gettype($parentCustomerID)), __LINE__);
        }
        if (is_null($parentCustomerID) || (is_array($parentCustomerID) && empty($parentCustomerID))) {
            unset($this->ParentCustomerID);
        } else {
            $this->ParentCustomerID = $parentCustomerID;
        }
        return $this;
    }
    /**
     * Get Phone1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone1()
    {
        return isset($this->Phone1) ? $this->Phone1 : null;
    }
    /**
     * Set Phone1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone1
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setPhone1($phone1 = null)
    {
        // validation for constraint: string
        if (!is_null($phone1) && !is_string($phone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone1, true), gettype($phone1)), __LINE__);
        }
        if (is_null($phone1) || (is_array($phone1) && empty($phone1))) {
            unset($this->Phone1);
        } else {
            $this->Phone1 = $phone1;
        }
        return $this;
    }
    /**
     * Get Phone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone2()
    {
        return isset($this->Phone2) ? $this->Phone2 : null;
    }
    /**
     * Set Phone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone2
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone2, true), gettype($phone2)), __LINE__);
        }
        if (is_null($phone2) || (is_array($phone2) && empty($phone2))) {
            unset($this->Phone2);
        } else {
            $this->Phone2 = $phone2;
        }
        return $this;
    }
    /**
     * Get Phone3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone3()
    {
        return isset($this->Phone3) ? $this->Phone3 : null;
    }
    /**
     * Set Phone3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone3
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setPhone3($phone3 = null)
    {
        // validation for constraint: string
        if (!is_null($phone3) && !is_string($phone3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone3, true), gettype($phone3)), __LINE__);
        }
        if (is_null($phone3) || (is_array($phone3) && empty($phone3))) {
            unset($this->Phone3);
        } else {
            $this->Phone3 = $phone3;
        }
        return $this;
    }
    /**
     * Get PostalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPostalCode()
    {
        return isset($this->PostalCode) ? $this->PostalCode : null;
    }
    /**
     * Set PostalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $postalCode
     * @return \Easy\EasyStruct\EasyClsCustomerCostCenter
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: float
        if (!is_null($postalCode) && !(is_float($postalCode) || is_numeric($postalCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        if (is_null($postalCode) || (is_array($postalCode) && empty($postalCode))) {
            unset($this->PostalCode);
        } else {
            $this->PostalCode = $postalCode;
        }
        return $this;
    }
}
