<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckSpecials EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyCheckSpecials extends AbstractStructBase
{
    /**
     * The Special1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Special1;
    /**
     * The Special2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Special2;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for CheckSpecials
     * @uses EasyCheckSpecials::setSpecial1()
     * @uses EasyCheckSpecials::setSpecial2()
     * @uses EasyCheckSpecials::setCredential()
     * @param string $special1
     * @param string $special2
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct($special1 = null, $special2 = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setSpecial1($special1)
            ->setSpecial2($special2)
            ->setCredential($credential);
    }
    /**
     * Get Special1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecial1()
    {
        return isset($this->Special1) ? $this->Special1 : null;
    }
    /**
     * Set Special1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $special1
     * @return \Easy\EasyStruct\EasyCheckSpecials
     */
    public function setSpecial1($special1 = null)
    {
        // validation for constraint: string
        if (!is_null($special1) && !is_string($special1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($special1, true), gettype($special1)), __LINE__);
        }
        if (is_null($special1) || (is_array($special1) && empty($special1))) {
            unset($this->Special1);
        } else {
            $this->Special1 = $special1;
        }
        return $this;
    }
    /**
     * Get Special2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecial2()
    {
        return isset($this->Special2) ? $this->Special2 : null;
    }
    /**
     * Set Special2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $special2
     * @return \Easy\EasyStruct\EasyCheckSpecials
     */
    public function setSpecial2($special2 = null)
    {
        // validation for constraint: string
        if (!is_null($special2) && !is_string($special2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($special2, true), gettype($special2)), __LINE__);
        }
        if (is_null($special2) || (is_array($special2) && empty($special2))) {
            unset($this->Special2);
        } else {
            $this->Special2 = $special2;
        }
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyCheckSpecials
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
