<?php

namespace Easy\EasyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert EasyService
 * @package Easy
 * @subpackage Services
 */
class EasyInsert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyInsertVoucher $parameters
     * @return \Easy\EasyStruct\EasyInsertVoucherResponse|bool
     */
    public function InsertVoucher(\Easy\EasyStruct\EasyInsertVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCustomerCostCenter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyInsertCustomerCostCenter $parameters
     * @return \Easy\EasyStruct\EasyInsertCustomerCostCenterResponse|bool
     */
    public function InsertCustomerCostCenter(\Easy\EasyStruct\EasyInsertCustomerCostCenter $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertCustomerCostCenter($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertPickUpOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyInsertPickUpOrder $parameters
     * @return \Easy\EasyStruct\EasyInsertPickUpOrderResponse|bool
     */
    public function InsertPickUpOrder(\Easy\EasyStruct\EasyInsertPickUpOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InsertPickUpOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Easy\EasyStruct\EasyInsertCustomerCostCenterResponse|\Easy\EasyStruct\EasyInsertPickUpOrderResponse|\Easy\EasyStruct\EasyInsertVoucherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
