<?php

namespace Easy\EasyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload EasyService
 * @package Easy
 * @subpackage Services
 */
class EasyUpload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Upload_XL_File
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyUpload_XL_File $parameters
     * @return \Easy\EasyStruct\EasyUpload_XL_FileResponse|bool
     */
    public function Upload_XL_File(\Easy\EasyStruct\EasyUpload_XL_File $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Upload_XL_File($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Easy\EasyStruct\EasyUpload_XL_FileResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
