<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackPickUpOrderByPickUpOrderID EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyTrackPickUpOrderByPickUpOrderID extends AbstractStructBase
{
    /**
     * The PickUpOrderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickUpOrderID;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The myClsCredential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $myClsCredential;
    /**
     * Constructor method for TrackPickUpOrderByPickUpOrderID
     * @uses EasyTrackPickUpOrderByPickUpOrderID::setPickUpOrderID()
     * @uses EasyTrackPickUpOrderByPickUpOrderID::setLanguage()
     * @uses EasyTrackPickUpOrderByPickUpOrderID::setMyClsCredential()
     * @param int $pickUpOrderID
     * @param string $language
     * @param \Easy\EasyStruct\EasyClsCredential $myClsCredential
     */
    public function __construct($pickUpOrderID = null, $language = null, \Easy\EasyStruct\EasyClsCredential $myClsCredential = null)
    {
        $this
            ->setPickUpOrderID($pickUpOrderID)
            ->setLanguage($language)
            ->setMyClsCredential($myClsCredential);
    }
    /**
     * Get PickUpOrderID value
     * @return int|null
     */
    public function getPickUpOrderID()
    {
        return $this->PickUpOrderID;
    }
    /**
     * Set PickUpOrderID value
     * @param int $pickUpOrderID
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderID
     */
    public function setPickUpOrderID($pickUpOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($pickUpOrderID) && !(is_int($pickUpOrderID) || ctype_digit($pickUpOrderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickUpOrderID, true), gettype($pickUpOrderID)), __LINE__);
        }
        $this->PickUpOrderID = $pickUpOrderID;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderID
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get myClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getMyClsCredential()
    {
        return isset($this->myClsCredential) ? $this->myClsCredential : null;
    }
    /**
     * Set myClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $myClsCredential
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderID
     */
    public function setMyClsCredential(\Easy\EasyStruct\EasyClsCredential $myClsCredential = null)
    {
        if (is_null($myClsCredential) || (is_array($myClsCredential) && empty($myClsCredential))) {
            unset($this->myClsCredential);
        } else {
            $this->myClsCredential = $myClsCredential;
        }
        return $this;
    }
}
