<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVouchersTracking_By_ItemID EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetVouchersTracking_By_ItemID extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The ClsCredential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $ClsCredential;
    /**
     * Constructor method for GetVouchersTracking_By_ItemID
     * @uses EasyGetVouchersTracking_By_ItemID::setItemID()
     * @uses EasyGetVouchersTracking_By_ItemID::setLanguage()
     * @uses EasyGetVouchersTracking_By_ItemID::setClsCredential()
     * @param string $itemID
     * @param string $language
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     */
    public function __construct($itemID = null, $language = null, \Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        $this
            ->setItemID($itemID)
            ->setLanguage($language)
            ->setClsCredential($clsCredential);
    }
    /**
     * Get ItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID()
    {
        return isset($this->ItemID) ? $this->ItemID : null;
    }
    /**
     * Set ItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID
     * @return \Easy\EasyStruct\EasyGetVouchersTracking_By_ItemID
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        if (is_null($itemID) || (is_array($itemID) && empty($itemID))) {
            unset($this->ItemID);
        } else {
            $this->ItemID = $itemID;
        }
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Easy\EasyStruct\EasyGetVouchersTracking_By_ItemID
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get ClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getClsCredential()
    {
        return isset($this->ClsCredential) ? $this->ClsCredential : null;
    }
    /**
     * Set ClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     * @return \Easy\EasyStruct\EasyGetVouchersTracking_By_ItemID
     */
    public function setClsCredential(\Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        if (is_null($clsCredential) || (is_array($clsCredential) && empty($clsCredential))) {
            unset($this->ClsCredential);
        } else {
            $this->ClsCredential = $clsCredential;
        }
        return $this;
    }
}
