<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherTracking_By_ItemID EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetVoucherTracking_By_ItemID extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetVoucherTracking_By_ItemID
     * @uses EasyGetVoucherTracking_By_ItemID::setItemID()
     * @uses EasyGetVoucherTracking_By_ItemID::setLanguage()
     * @uses EasyGetVoucherTracking_By_ItemID::setCredential()
     * @param string $itemID
     * @param string $language
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct($itemID = null, $language = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setItemID($itemID)
            ->setLanguage($language)
            ->setCredential($credential);
    }
    /**
     * Get ItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID()
    {
        return isset($this->ItemID) ? $this->ItemID : null;
    }
    /**
     * Set ItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID
     * @return \Easy\EasyStruct\EasyGetVoucherTracking_By_ItemID
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        if (is_null($itemID) || (is_array($itemID) && empty($itemID))) {
            unset($this->ItemID);
        } else {
            $this->ItemID = $itemID;
        }
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Easy\EasyStruct\EasyGetVoucherTracking_By_ItemID
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyGetVoucherTracking_By_ItemID
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
