<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherPOD EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetVoucherPOD extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The ClsCredential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $ClsCredential;
    /**
     * Constructor method for GetVoucherPOD
     * @uses EasyGetVoucherPOD::setShipmentNumber()
     * @uses EasyGetVoucherPOD::setClsCredential()
     * @param float $shipmentNumber
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     */
    public function __construct($shipmentNumber = null, \Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setClsCredential($clsCredential);
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \Easy\EasyStruct\EasyGetVoucherPOD
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get ClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getClsCredential()
    {
        return isset($this->ClsCredential) ? $this->ClsCredential : null;
    }
    /**
     * Set ClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     * @return \Easy\EasyStruct\EasyGetVoucherPOD
     */
    public function setClsCredential(\Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        if (is_null($clsCredential) || (is_array($clsCredential) && empty($clsCredential))) {
            unset($this->ClsCredential);
        } else {
            $this->ClsCredential = $clsCredential;
        }
        return $this;
    }
}
