<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShipmentNumber EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetShipmentNumber extends AbstractStructBase
{
    /**
     * The iType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iType;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetShipmentNumber
     * @uses EasyGetShipmentNumber::setIType()
     * @uses EasyGetShipmentNumber::setCredential()
     * @param int $iType
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct($iType = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setIType($iType)
            ->setCredential($credential);
    }
    /**
     * Get iType value
     * @return int|null
     */
    public function getIType()
    {
        return $this->iType;
    }
    /**
     * Set iType value
     * @param int $iType
     * @return \Easy\EasyStruct\EasyGetShipmentNumber
     */
    public function setIType($iType = null)
    {
        // validation for constraint: int
        if (!is_null($iType) && !(is_int($iType) || ctype_digit($iType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iType, true), gettype($iType)), __LINE__);
        }
        $this->iType = $iType;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyGetShipmentNumber
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
