<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPickUpOrder EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyCancelPickUpOrder extends AbstractStructBase
{
    /**
     * The PickUpOrderID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PickUpOrderID;
    /**
     * The ClsCredential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $ClsCredential;
    /**
     * Constructor method for CancelPickUpOrder
     * @uses EasyCancelPickUpOrder::setPickUpOrderID()
     * @uses EasyCancelPickUpOrder::setClsCredential()
     * @param int $pickUpOrderID
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     */
    public function __construct($pickUpOrderID = null, \Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        $this
            ->setPickUpOrderID($pickUpOrderID)
            ->setClsCredential($clsCredential);
    }
    /**
     * Get PickUpOrderID value
     * @return int|null
     */
    public function getPickUpOrderID()
    {
        return $this->PickUpOrderID;
    }
    /**
     * Set PickUpOrderID value
     * @param int $pickUpOrderID
     * @return \Easy\EasyStruct\EasyCancelPickUpOrder
     */
    public function setPickUpOrderID($pickUpOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($pickUpOrderID) && !(is_int($pickUpOrderID) || ctype_digit($pickUpOrderID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pickUpOrderID, true), gettype($pickUpOrderID)), __LINE__);
        }
        $this->PickUpOrderID = $pickUpOrderID;
        return $this;
    }
    /**
     * Get ClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getClsCredential()
    {
        return isset($this->ClsCredential) ? $this->ClsCredential : null;
    }
    /**
     * Set ClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     * @return \Easy\EasyStruct\EasyCancelPickUpOrder
     */
    public function setClsCredential(\Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        if (is_null($clsCredential) || (is_array($clsCredential) && empty($clsCredential))) {
            unset($this->ClsCredential);
        } else {
            $this->ClsCredential = $clsCredential;
        }
        return $this;
    }
}
