<?php

namespace Easy\EasyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get EasyService
 * @package Easy
 * @subpackage Services
 */
class EasyGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetData $parameters
     * @return \Easy\EasyStruct\EasyGetDataResponse|bool
     */
    public function GetData(\Easy\EasyStruct\EasyGetData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataUsingDataContract
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetDataUsingDataContract $parameters
     * @return \Easy\EasyStruct\EasyGetDataUsingDataContractResponse|bool
     */
    public function GetDataUsingDataContract(\Easy\EasyStruct\EasyGetDataUsingDataContract $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataUsingDataContract($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetShipmentNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetShipmentNumber $parameters
     * @return \Easy\EasyStruct\EasyGetShipmentNumberResponse|bool
     */
    public function GetShipmentNumber(\Easy\EasyStruct\EasyGetShipmentNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetShipmentNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucher $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherResponse|bool
     */
    public function GetVoucher(\Easy\EasyStruct\EasyGetVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherMargins
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherMargins $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherMarginsResponse|bool
     */
    public function GetVoucherMargins(\Easy\EasyStruct\EasyGetVoucherMargins $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherMargins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPdf_Background
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherPdf_Background $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherPdf_BackgroundResponse|bool
     */
    public function GetVoucherPdf_Background(\Easy\EasyStruct\EasyGetVoucherPdf_Background $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPdf_Background($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTracking
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherTracking $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherTrackingResponse|bool
     */
    public function GetVoucherTracking(\Easy\EasyStruct\EasyGetVoucherTracking $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherTracking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTrackingLanguage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherTrackingLanguage $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherTrackingLanguageResponse|bool
     */
    public function GetVoucherTrackingLanguage(\Easy\EasyStruct\EasyGetVoucherTrackingLanguage $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherTrackingLanguage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTracking_Station
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherTracking_Station $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherTracking_StationResponse|bool
     */
    public function GetVoucherTracking_Station(\Easy\EasyStruct\EasyGetVoucherTracking_Station $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherTracking_Station($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersTracking_By_TimePeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriod $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriodResponse|bool
     */
    public function GetVouchersTracking_By_TimePeriod(\Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersTracking_By_TimePeriod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersTracking_By_TimePeriod2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriod2 $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriod2Response|bool
     */
    public function GetVouchersTracking_By_TimePeriod2(\Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriod2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersTracking_By_TimePeriod2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersTracking_By_ItemID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersTracking_By_ItemID $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersTracking_By_ItemIDResponse|bool
     */
    public function GetVouchersTracking_By_ItemID(\Easy\EasyStruct\EasyGetVouchersTracking_By_ItemID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersTracking_By_ItemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherTracking_By_ItemID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherTracking_By_ItemID $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherTracking_By_ItemIDResponse|bool
     */
    public function GetVoucherTracking_By_ItemID(\Easy\EasyStruct\EasyGetVoucherTracking_By_ItemID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherTracking_By_ItemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersXps
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersXps $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersXpsResponse|bool
     */
    public function GetVouchersXps(\Easy\EasyStruct\EasyGetVouchersXps $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersXps($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersXps_Url
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersXps_Url $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersXps_UrlResponse|bool
     */
    public function GetVouchersXps_Url(\Easy\EasyStruct\EasyGetVouchersXps_Url $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersXps_Url($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersPdf $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersPdfResponse|bool
     */
    public function GetVouchersPdf(\Easy\EasyStruct\EasyGetVouchersPdf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersPdf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf_Url
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersPdf_Url $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersPdf_UrlResponse|bool
     */
    public function GetVouchersPdf_Url(\Easy\EasyStruct\EasyGetVouchersPdf_Url $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersPdf_Url($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchers_Str_Pdf_Url
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchers_Str_Pdf_Url $parameters
     * @return \Easy\EasyStruct\EasyGetVouchers_Str_Pdf_UrlResponse|bool
     */
    public function GetVouchers_Str_Pdf_Url(\Easy\EasyStruct\EasyGetVouchers_Str_Pdf_Url $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchers_Str_Pdf_Url($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf2A4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersPdf2A4 $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersPdf2A4Response|bool
     */
    public function GetVouchersPdf2A4(\Easy\EasyStruct\EasyGetVouchersPdf2A4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersPdf2A4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPOD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherPOD $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherPODResponse|bool
     */
    public function GetVoucherPOD(\Easy\EasyStruct\EasyGetVoucherPOD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVouchersPdf3A4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVouchersPdf3A4 $parameters
     * @return \Easy\EasyStruct\EasyGetVouchersPdf3A4Response|bool
     */
    public function GetVouchersPdf3A4(\Easy\EasyStruct\EasyGetVouchersPdf3A4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVouchersPdf3A4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetCustomer $parameters
     * @return \Easy\EasyStruct\EasyGetCustomerResponse|bool
     */
    public function GetCustomer(\Easy\EasyStruct\EasyGetCustomer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFA6Margins
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherPDFA6Margins $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherPDFA6MarginsResponse|bool
     */
    public function GetVoucherPDFA6Margins(\Easy\EasyStruct\EasyGetVoucherPDFA6Margins $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPDFA6Margins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFMargins
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherPDFMargins $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherPDFMarginsResponse|bool
     */
    public function GetVoucherPDFMargins(\Easy\EasyStruct\EasyGetVoucherPDFMargins $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPDFMargins($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFA4Double
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherPDFA4Double $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherPDFA4DoubleResponse|bool
     */
    public function GetVoucherPDFA4Double(\Easy\EasyStruct\EasyGetVoucherPDFA4Double $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPDFA4Double($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoucherPDFA4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyGetVoucherPDFA4 $parameters
     * @return \Easy\EasyStruct\EasyGetVoucherPDFA4Response|bool
     */
    public function GetVoucherPDFA4(\Easy\EasyStruct\EasyGetVoucherPDFA4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetVoucherPDFA4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Easy\EasyStruct\EasyGetCustomerResponse|\Easy\EasyStruct\EasyGetDataResponse|\Easy\EasyStruct\EasyGetDataUsingDataContractResponse|\Easy\EasyStruct\EasyGetShipmentNumberResponse|\Easy\EasyStruct\EasyGetVoucherMarginsResponse|\Easy\EasyStruct\EasyGetVoucherPDFA4DoubleResponse|\Easy\EasyStruct\EasyGetVoucherPDFA4Response|\Easy\EasyStruct\EasyGetVoucherPDFA6MarginsResponse|\Easy\EasyStruct\EasyGetVoucherPDFMarginsResponse|\Easy\EasyStruct\EasyGetVoucherPdf_BackgroundResponse|\Easy\EasyStruct\EasyGetVoucherPODResponse|\Easy\EasyStruct\EasyGetVoucherResponse|\Easy\EasyStruct\EasyGetVouchersPdf2A4Response|\Easy\EasyStruct\EasyGetVouchersPdf3A4Response|\Easy\EasyStruct\EasyGetVouchersPdfResponse|\Easy\EasyStruct\EasyGetVouchersPdf_UrlResponse|\Easy\EasyStruct\EasyGetVouchersTracking_By_ItemIDResponse|\Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriod2Response|\Easy\EasyStruct\EasyGetVouchersTracking_By_TimePeriodResponse|\Easy\EasyStruct\EasyGetVouchersXpsResponse|\Easy\EasyStruct\EasyGetVouchersXps_UrlResponse|\Easy\EasyStruct\EasyGetVouchers_Str_Pdf_UrlResponse|\Easy\EasyStruct\EasyGetVoucherTrackingLanguageResponse|\Easy\EasyStruct\EasyGetVoucherTrackingResponse|\Easy\EasyStruct\EasyGetVoucherTracking_By_ItemIDResponse|\Easy\EasyStruct\EasyGetVoucherTracking_StationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
