<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackPickUpOrderByItemID EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyTrackPickUpOrderByItemID extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemID;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The myClsCredential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $myClsCredential;
    /**
     * Constructor method for TrackPickUpOrderByItemID
     * @uses EasyTrackPickUpOrderByItemID::setItemID()
     * @uses EasyTrackPickUpOrderByItemID::setLanguage()
     * @uses EasyTrackPickUpOrderByItemID::setMyClsCredential()
     * @param string $itemID
     * @param string $language
     * @param \Easy\EasyStruct\EasyClsCredential $myClsCredential
     */
    public function __construct($itemID = null, $language = null, \Easy\EasyStruct\EasyClsCredential $myClsCredential = null)
    {
        $this
            ->setItemID($itemID)
            ->setLanguage($language)
            ->setMyClsCredential($myClsCredential);
    }
    /**
     * Get ItemID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemID()
    {
        return isset($this->ItemID) ? $this->ItemID : null;
    }
    /**
     * Set ItemID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemID
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByItemID
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        if (is_null($itemID) || (is_array($itemID) && empty($itemID))) {
            unset($this->ItemID);
        } else {
            $this->ItemID = $itemID;
        }
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByItemID
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get myClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getMyClsCredential()
    {
        return isset($this->myClsCredential) ? $this->myClsCredential : null;
    }
    /**
     * Set myClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $myClsCredential
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByItemID
     */
    public function setMyClsCredential(\Easy\EasyStruct\EasyClsCredential $myClsCredential = null)
    {
        if (is_null($myClsCredential) || (is_array($myClsCredential) && empty($myClsCredential))) {
            unset($this->myClsCredential);
        } else {
            $this->myClsCredential = $myClsCredential;
        }
        return $this;
    }
}
