<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsertVoucher EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyInsertVoucher extends AbstractStructBase
{
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsVoucher
     */
    public $Voucher;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for InsertVoucher
     * @uses EasyInsertVoucher::setVoucher()
     * @uses EasyInsertVoucher::setCredential()
     * @param \Easy\EasyStruct\EasyClsVoucher $voucher
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct(\Easy\EasyStruct\EasyClsVoucher $voucher = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setVoucher($voucher)
            ->setCredential($credential);
    }
    /**
     * Get Voucher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsVoucher|null
     */
    public function getVoucher()
    {
        return isset($this->Voucher) ? $this->Voucher : null;
    }
    /**
     * Set Voucher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsVoucher $voucher
     * @return \Easy\EasyStruct\EasyInsertVoucher
     */
    public function setVoucher(\Easy\EasyStruct\EasyClsVoucher $voucher = null)
    {
        if (is_null($voucher) || (is_array($voucher) && empty($voucher))) {
            unset($this->Voucher);
        } else {
            $this->Voucher = $voucher;
        }
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyInsertVoucher
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
