<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherTrackingLanguage EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetVoucherTrackingLanguage extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetVoucherTrackingLanguage
     * @uses EasyGetVoucherTrackingLanguage::setShipmentNumber()
     * @uses EasyGetVoucherTrackingLanguage::setLanguage()
     * @uses EasyGetVoucherTrackingLanguage::setCredential()
     * @param float $shipmentNumber
     * @param string $language
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct($shipmentNumber = null, $language = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setLanguage($language)
            ->setCredential($credential);
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \Easy\EasyStruct\EasyGetVoucherTrackingLanguage
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \Easy\EasyStruct\EasyGetVoucherTrackingLanguage
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyGetVoucherTrackingLanguage
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
