<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucher EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetVoucher extends AbstractStructBase
{
    /**
     * The ShipmentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ShipmentNumber;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for GetVoucher
     * @uses EasyGetVoucher::setShipmentNumber()
     * @uses EasyGetVoucher::setCredential()
     * @param float $shipmentNumber
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct($shipmentNumber = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setCredential($credential);
    }
    /**
     * Get ShipmentNumber value
     * @return float|null
     */
    public function getShipmentNumber()
    {
        return $this->ShipmentNumber;
    }
    /**
     * Set ShipmentNumber value
     * @param float $shipmentNumber
     * @return \Easy\EasyStruct\EasyGetVoucher
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: float
        if (!is_null($shipmentNumber) && !(is_float($shipmentNumber) || is_numeric($shipmentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        $this->ShipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyGetVoucher
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
