<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetData EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetData extends AbstractStructBase
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $value;
    /**
     * Constructor method for GetData
     * @uses EasyGetData::setValue()
     * @param int $value
     */
    public function __construct($value = null)
    {
        $this
            ->setValue($value);
    }
    /**
     * Get value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param int $value
     * @return \Easy\EasyStruct\EasyGetData
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
