<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClsCancelVoucherResp EasyStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClsCancelVoucherResp
 * @package Easy
 * @subpackage Structs
 */
class EasyClsCancelVoucherResp extends AbstractStructBase
{
    /**
     * The Canceled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Canceled;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Message;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Result;
    /**
     * Constructor method for ClsCancelVoucherResp
     * @uses EasyClsCancelVoucherResp::setCanceled()
     * @uses EasyClsCancelVoucherResp::setMessage()
     * @uses EasyClsCancelVoucherResp::setResult()
     * @param bool $canceled
     * @param string $message
     * @param bool $result
     */
    public function __construct($canceled = null, $message = null, $result = null)
    {
        $this
            ->setCanceled($canceled)
            ->setMessage($message)
            ->setResult($result);
    }
    /**
     * Get Canceled value
     * @return bool|null
     */
    public function getCanceled()
    {
        return $this->Canceled;
    }
    /**
     * Set Canceled value
     * @param bool $canceled
     * @return \Easy\EasyStruct\EasyClsCancelVoucherResp
     */
    public function setCanceled($canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($canceled) && !is_bool($canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canceled, true), gettype($canceled)), __LINE__);
        }
        $this->Canceled = $canceled;
        return $this;
    }
    /**
     * Get Message value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessage()
    {
        return isset($this->Message) ? $this->Message : null;
    }
    /**
     * Set Message value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $message
     * @return \Easy\EasyStruct\EasyClsCancelVoucherResp
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        if (is_null($message) || (is_array($message) && empty($message))) {
            unset($this->Message);
        } else {
            $this->Message = $message;
        }
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return \Easy\EasyStruct\EasyClsCancelVoucherResp
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
