<?php

namespace Easy\EasyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Track EasyService
 * @package Easy
 * @subpackage Services
 */
class EasyTrack extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TrackPickUpOrderByPickUpOrderID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderID $parameters
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderIDResponse|bool
     */
    public function TrackPickUpOrderByPickUpOrderID(\Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackPickUpOrderByPickUpOrderID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrackPickUpOrderByItemID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyTrackPickUpOrderByItemID $parameters
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByItemIDResponse|bool
     */
    public function TrackPickUpOrderByItemID(\Easy\EasyStruct\EasyTrackPickUpOrderByItemID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackPickUpOrderByItemID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrackPickUpOrderByShipmentNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyTrackPickUpOrderByShipmentNumber $parameters
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByShipmentNumberResponse|bool
     */
    public function TrackPickUpOrderByShipmentNumber(\Easy\EasyStruct\EasyTrackPickUpOrderByShipmentNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackPickUpOrderByShipmentNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Easy\EasyStruct\EasyTrackPickUpOrderByItemIDResponse|\Easy\EasyStruct\EasyTrackPickUpOrderByPickUpOrderIDResponse|\Easy\EasyStruct\EasyTrackPickUpOrderByShipmentNumberResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
