<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Upload_XL_File EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyUpload_XL_File extends AbstractStructBase
{
    /**
     * The XL_File
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XL_File;
    /**
     * The Credential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $Credential;
    /**
     * Constructor method for Upload_XL_File
     * @uses EasyUpload_XL_File::setXL_File()
     * @uses EasyUpload_XL_File::setCredential()
     * @param string $xL_File
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     */
    public function __construct($xL_File = null, \Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        $this
            ->setXL_File($xL_File)
            ->setCredential($credential);
    }
    /**
     * Get XL_File value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXL_File()
    {
        return isset($this->XL_File) ? $this->XL_File : null;
    }
    /**
     * Set XL_File value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xL_File
     * @return \Easy\EasyStruct\EasyUpload_XL_File
     */
    public function setXL_File($xL_File = null)
    {
        // validation for constraint: string
        if (!is_null($xL_File) && !is_string($xL_File)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xL_File, true), gettype($xL_File)), __LINE__);
        }
        if (is_null($xL_File) || (is_array($xL_File) && empty($xL_File))) {
            unset($this->XL_File);
        } else {
            $this->XL_File = $xL_File;
        }
        return $this;
    }
    /**
     * Get Credential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getCredential()
    {
        return isset($this->Credential) ? $this->Credential : null;
    }
    /**
     * Set Credential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $credential
     * @return \Easy\EasyStruct\EasyUpload_XL_File
     */
    public function setCredential(\Easy\EasyStruct\EasyClsCredential $credential = null)
    {
        if (is_null($credential) || (is_array($credential) && empty($credential))) {
            unset($this->Credential);
        } else {
            $this->Credential = $credential;
        }
        return $this;
    }
}
