<?php

namespace Easy\EasyStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomer EasyStruct
 * @package Easy
 * @subpackage Structs
 */
class EasyGetCustomer extends AbstractStructBase
{
    /**
     * The CustomerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CustomerID;
    /**
     * The ClsCredential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Easy\EasyStruct\EasyClsCredential
     */
    public $ClsCredential;
    /**
     * Constructor method for GetCustomer
     * @uses EasyGetCustomer::setCustomerID()
     * @uses EasyGetCustomer::setClsCredential()
     * @param int $customerID
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     */
    public function __construct($customerID = null, \Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setClsCredential($clsCredential);
    }
    /**
     * Get CustomerID value
     * @return int|null
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \Easy\EasyStruct\EasyGetCustomer
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !(is_int($customerID) || ctype_digit($customerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get ClsCredential value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Easy\EasyStruct\EasyClsCredential|null
     */
    public function getClsCredential()
    {
        return isset($this->ClsCredential) ? $this->ClsCredential : null;
    }
    /**
     * Set ClsCredential value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Easy\EasyStruct\EasyClsCredential $clsCredential
     * @return \Easy\EasyStruct\EasyGetCustomer
     */
    public function setClsCredential(\Easy\EasyStruct\EasyClsCredential $clsCredential = null)
    {
        if (is_null($clsCredential) || (is_array($clsCredential) && empty($clsCredential))) {
            unset($this->ClsCredential);
        } else {
            $this->ClsCredential = $clsCredential;
        }
        return $this;
    }
}
