<?php

namespace Easy\EasyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Check EasyService
 * @package Easy
 * @subpackage Services
 */
class EasyCheck extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CheckSpecials
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyCheckSpecials $parameters
     * @return \Easy\EasyStruct\EasyCheckSpecialsResponse|bool
     */
    public function CheckSpecials(\Easy\EasyStruct\EasyCheckSpecials $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CheckSpecials($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Easy\EasyStruct\EasyCheckSpecialsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
