<?php

namespace Easy\EasyService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel EasyService
 * @package Easy
 * @subpackage Services
 */
class EasyCancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelVoucher
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyCancelVoucher $parameters
     * @return \Easy\EasyStruct\EasyCancelVoucherResponse|bool
     */
    public function CancelVoucher(\Easy\EasyStruct\EasyCancelVoucher $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelVoucher($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelPickUpOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Easy\EasyStruct\EasyCancelPickUpOrder $parameters
     * @return \Easy\EasyStruct\EasyCancelPickUpOrderResponse|bool
     */
    public function CancelPickUpOrder(\Easy\EasyStruct\EasyCancelPickUpOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelPickUpOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Easy\EasyStruct\EasyCancelPickUpOrderResponse|\Easy\EasyStruct\EasyCancelVoucherResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
