<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebIdadeOdeme StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebIdadeOdeme
 * @subpackage Structs
 */
class WebIdadeOdeme extends AbstractStructBase
{
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IbanAdiSoyadi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IbanAdiSoyadi;
    /**
     * The KullaniciAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KullaniciAdi;
    /**
     * The KullaniciID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KullaniciID;
    /**
     * The OdemeDurumu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OdemeDurumu;
    /**
     * The OdemeTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OdemeTipi;
    /**
     * The SiparisID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SiparisID;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Tarih;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Tutar;
    /**
     * The UyeAdi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeAdi;
    /**
     * Constructor method for WebIdadeOdeme
     * @uses WebIdadeOdeme::setIBAN()
     * @uses WebIdadeOdeme::setID()
     * @uses WebIdadeOdeme::setIbanAdiSoyadi()
     * @uses WebIdadeOdeme::setKullaniciAdi()
     * @uses WebIdadeOdeme::setKullaniciID()
     * @uses WebIdadeOdeme::setOdemeDurumu()
     * @uses WebIdadeOdeme::setOdemeTipi()
     * @uses WebIdadeOdeme::setSiparisID()
     * @uses WebIdadeOdeme::setTarih()
     * @uses WebIdadeOdeme::setTutar()
     * @uses WebIdadeOdeme::setUyeAdi()
     * @param string $iBAN
     * @param int $iD
     * @param string $ibanAdiSoyadi
     * @param string $kullaniciAdi
     * @param int $kullaniciID
     * @param string $odemeDurumu
     * @param int $odemeTipi
     * @param int $siparisID
     * @param string $tarih
     * @param float $tutar
     * @param string $uyeAdi
     */
    public function __construct($iBAN = null, $iD = null, $ibanAdiSoyadi = null, $kullaniciAdi = null, $kullaniciID = null, $odemeDurumu = null, $odemeTipi = null, $siparisID = null, $tarih = null, $tutar = null, $uyeAdi = null)
    {
        $this
            ->setIBAN($iBAN)
            ->setID($iD)
            ->setIbanAdiSoyadi($ibanAdiSoyadi)
            ->setKullaniciAdi($kullaniciAdi)
            ->setKullaniciID($kullaniciID)
            ->setOdemeDurumu($odemeDurumu)
            ->setOdemeTipi($odemeTipi)
            ->setSiparisID($siparisID)
            ->setTarih($tarih)
            ->setTutar($tutar)
            ->setUyeAdi($uyeAdi);
    }
    /**
     * Get IBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * Set IBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBAN
     * @return \StructType\WebIdadeOdeme
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\WebIdadeOdeme
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IbanAdiSoyadi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIbanAdiSoyadi()
    {
        return isset($this->IbanAdiSoyadi) ? $this->IbanAdiSoyadi : null;
    }
    /**
     * Set IbanAdiSoyadi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ibanAdiSoyadi
     * @return \StructType\WebIdadeOdeme
     */
    public function setIbanAdiSoyadi($ibanAdiSoyadi = null)
    {
        // validation for constraint: string
        if (!is_null($ibanAdiSoyadi) && !is_string($ibanAdiSoyadi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ibanAdiSoyadi, true), gettype($ibanAdiSoyadi)), __LINE__);
        }
        if (is_null($ibanAdiSoyadi) || (is_array($ibanAdiSoyadi) && empty($ibanAdiSoyadi))) {
            unset($this->IbanAdiSoyadi);
        } else {
            $this->IbanAdiSoyadi = $ibanAdiSoyadi;
        }
        return $this;
    }
    /**
     * Get KullaniciAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKullaniciAdi()
    {
        return isset($this->KullaniciAdi) ? $this->KullaniciAdi : null;
    }
    /**
     * Set KullaniciAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kullaniciAdi
     * @return \StructType\WebIdadeOdeme
     */
    public function setKullaniciAdi($kullaniciAdi = null)
    {
        // validation for constraint: string
        if (!is_null($kullaniciAdi) && !is_string($kullaniciAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kullaniciAdi, true), gettype($kullaniciAdi)), __LINE__);
        }
        if (is_null($kullaniciAdi) || (is_array($kullaniciAdi) && empty($kullaniciAdi))) {
            unset($this->KullaniciAdi);
        } else {
            $this->KullaniciAdi = $kullaniciAdi;
        }
        return $this;
    }
    /**
     * Get KullaniciID value
     * @return int|null
     */
    public function getKullaniciID()
    {
        return $this->KullaniciID;
    }
    /**
     * Set KullaniciID value
     * @param int $kullaniciID
     * @return \StructType\WebIdadeOdeme
     */
    public function setKullaniciID($kullaniciID = null)
    {
        // validation for constraint: int
        if (!is_null($kullaniciID) && !(is_int($kullaniciID) || ctype_digit($kullaniciID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kullaniciID, true), gettype($kullaniciID)), __LINE__);
        }
        $this->KullaniciID = $kullaniciID;
        return $this;
    }
    /**
     * Get OdemeDurumu value
     * @return string|null
     */
    public function getOdemeDurumu()
    {
        return $this->OdemeDurumu;
    }
    /**
     * Set OdemeDurumu value
     * @uses \EnumType\WebIadeOdemeDurum::valueIsValid()
     * @uses \EnumType\WebIadeOdemeDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeDurumu
     * @return \StructType\WebIdadeOdeme
     */
    public function setOdemeDurumu($odemeDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebIadeOdemeDurum::valueIsValid($odemeDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebIadeOdemeDurum', is_array($odemeDurumu) ? implode(', ', $odemeDurumu) : var_export($odemeDurumu, true), implode(', ', \EnumType\WebIadeOdemeDurum::getValidValues())), __LINE__);
        }
        $this->OdemeDurumu = $odemeDurumu;
        return $this;
    }
    /**
     * Get OdemeTipi value
     * @return int|null
     */
    public function getOdemeTipi()
    {
        return $this->OdemeTipi;
    }
    /**
     * Set OdemeTipi value
     * @param int $odemeTipi
     * @return \StructType\WebIdadeOdeme
     */
    public function setOdemeTipi($odemeTipi = null)
    {
        // validation for constraint: int
        if (!is_null($odemeTipi) && !(is_int($odemeTipi) || ctype_digit($odemeTipi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeTipi, true), gettype($odemeTipi)), __LINE__);
        }
        $this->OdemeTipi = $odemeTipi;
        return $this;
    }
    /**
     * Get SiparisID value
     * @return int|null
     */
    public function getSiparisID()
    {
        return $this->SiparisID;
    }
    /**
     * Set SiparisID value
     * @param int $siparisID
     * @return \StructType\WebIdadeOdeme
     */
    public function setSiparisID($siparisID = null)
    {
        // validation for constraint: int
        if (!is_null($siparisID) && !(is_int($siparisID) || ctype_digit($siparisID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siparisID, true), gettype($siparisID)), __LINE__);
        }
        $this->SiparisID = $siparisID;
        return $this;
    }
    /**
     * Get Tarih value
     * @return string|null
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \StructType\WebIdadeOdeme
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get Tutar value
     * @return float|null
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \StructType\WebIdadeOdeme
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
    /**
     * Get UyeAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeAdi()
    {
        return isset($this->UyeAdi) ? $this->UyeAdi : null;
    }
    /**
     * Set UyeAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeAdi
     * @return \StructType\WebIdadeOdeme
     */
    public function setUyeAdi($uyeAdi = null)
    {
        // validation for constraint: string
        if (!is_null($uyeAdi) && !is_string($uyeAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeAdi, true), gettype($uyeAdi)), __LINE__);
        }
        if (is_null($uyeAdi) || (is_array($uyeAdi) && empty($uyeAdi))) {
            unset($this->UyeAdi);
        } else {
            $this->UyeAdi = $uyeAdi;
        }
        return $this;
    }
}
