<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebIadeTalepGuncelleRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WebIadeTalepGuncelleRequest
 * @subpackage Structs
 */
class WebIadeTalepGuncelleRequest extends AbstractStructBase
{
    /**
     * The IadeKoduOlustur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IadeKoduOlustur;
    /**
     * The MailGonder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MailGonder;
    /**
     * The SiparisDurumu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SiparisDurumu;
    /**
     * The SiparisDurumuGuncelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SiparisDurumuGuncelle;
    /**
     * The Talep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IadeTalepUpdate
     */
    public $Talep;
    /**
     * The UrunleriGuncelle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UrunleriGuncelle;
    /**
     * Constructor method for WebIadeTalepGuncelleRequest
     * @uses WebIadeTalepGuncelleRequest::setIadeKoduOlustur()
     * @uses WebIadeTalepGuncelleRequest::setMailGonder()
     * @uses WebIadeTalepGuncelleRequest::setSiparisDurumu()
     * @uses WebIadeTalepGuncelleRequest::setSiparisDurumuGuncelle()
     * @uses WebIadeTalepGuncelleRequest::setTalep()
     * @uses WebIadeTalepGuncelleRequest::setUrunleriGuncelle()
     * @param bool $iadeKoduOlustur
     * @param bool $mailGonder
     * @param string $siparisDurumu
     * @param bool $siparisDurumuGuncelle
     * @param \StructType\IadeTalepUpdate $talep
     * @param bool $urunleriGuncelle
     */
    public function __construct($iadeKoduOlustur = null, $mailGonder = null, $siparisDurumu = null, $siparisDurumuGuncelle = null, \StructType\IadeTalepUpdate $talep = null, $urunleriGuncelle = null)
    {
        $this
            ->setIadeKoduOlustur($iadeKoduOlustur)
            ->setMailGonder($mailGonder)
            ->setSiparisDurumu($siparisDurumu)
            ->setSiparisDurumuGuncelle($siparisDurumuGuncelle)
            ->setTalep($talep)
            ->setUrunleriGuncelle($urunleriGuncelle);
    }
    /**
     * Get IadeKoduOlustur value
     * @return bool|null
     */
    public function getIadeKoduOlustur()
    {
        return $this->IadeKoduOlustur;
    }
    /**
     * Set IadeKoduOlustur value
     * @param bool $iadeKoduOlustur
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setIadeKoduOlustur($iadeKoduOlustur = null)
    {
        // validation for constraint: boolean
        if (!is_null($iadeKoduOlustur) && !is_bool($iadeKoduOlustur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iadeKoduOlustur, true), gettype($iadeKoduOlustur)), __LINE__);
        }
        $this->IadeKoduOlustur = $iadeKoduOlustur;
        return $this;
    }
    /**
     * Get MailGonder value
     * @return bool|null
     */
    public function getMailGonder()
    {
        return $this->MailGonder;
    }
    /**
     * Set MailGonder value
     * @param bool $mailGonder
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setMailGonder($mailGonder = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailGonder) && !is_bool($mailGonder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mailGonder, true), gettype($mailGonder)), __LINE__);
        }
        $this->MailGonder = $mailGonder;
        return $this;
    }
    /**
     * Get SiparisDurumu value
     * @return string|null
     */
    public function getSiparisDurumu()
    {
        return $this->SiparisDurumu;
    }
    /**
     * Set SiparisDurumu value
     * @uses \EnumType\WebSiparisDurumlari::valueIsValid()
     * @uses \EnumType\WebSiparisDurumlari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $siparisDurumu
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setSiparisDurumu($siparisDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebSiparisDurumlari::valueIsValid($siparisDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebSiparisDurumlari', is_array($siparisDurumu) ? implode(', ', $siparisDurumu) : var_export($siparisDurumu, true), implode(', ', \EnumType\WebSiparisDurumlari::getValidValues())), __LINE__);
        }
        $this->SiparisDurumu = $siparisDurumu;
        return $this;
    }
    /**
     * Get SiparisDurumuGuncelle value
     * @return bool|null
     */
    public function getSiparisDurumuGuncelle()
    {
        return $this->SiparisDurumuGuncelle;
    }
    /**
     * Set SiparisDurumuGuncelle value
     * @param bool $siparisDurumuGuncelle
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setSiparisDurumuGuncelle($siparisDurumuGuncelle = null)
    {
        // validation for constraint: boolean
        if (!is_null($siparisDurumuGuncelle) && !is_bool($siparisDurumuGuncelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($siparisDurumuGuncelle, true), gettype($siparisDurumuGuncelle)), __LINE__);
        }
        $this->SiparisDurumuGuncelle = $siparisDurumuGuncelle;
        return $this;
    }
    /**
     * Get Talep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IadeTalepUpdate|null
     */
    public function getTalep()
    {
        return isset($this->Talep) ? $this->Talep : null;
    }
    /**
     * Set Talep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IadeTalepUpdate $talep
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setTalep(\StructType\IadeTalepUpdate $talep = null)
    {
        if (is_null($talep) || (is_array($talep) && empty($talep))) {
            unset($this->Talep);
        } else {
            $this->Talep = $talep;
        }
        return $this;
    }
    /**
     * Get UrunleriGuncelle value
     * @return bool|null
     */
    public function getUrunleriGuncelle()
    {
        return $this->UrunleriGuncelle;
    }
    /**
     * Set UrunleriGuncelle value
     * @param bool $urunleriGuncelle
     * @return \StructType\WebIadeTalepGuncelleRequest
     */
    public function setUrunleriGuncelle($urunleriGuncelle = null)
    {
        // validation for constraint: boolean
        if (!is_null($urunleriGuncelle) && !is_bool($urunleriGuncelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($urunleriGuncelle, true), gettype($urunleriGuncelle)), __LINE__);
        }
        $this->UrunleriGuncelle = $urunleriGuncelle;
        return $this;
    }
}
