<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectWebhookRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SelectWebhookRequest
 * @subpackage Structs
 */
class SelectWebhookRequest extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IslemTipi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IslemTipi;
    /**
     * Constructor method for SelectWebhookRequest
     * @uses SelectWebhookRequest::setID()
     * @uses SelectWebhookRequest::setIslemTipi()
     * @param int $iD
     * @param string $islemTipi
     */
    public function __construct($iD = null, $islemTipi = null)
    {
        $this
            ->setID($iD)
            ->setIslemTipi($islemTipi);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\SelectWebhookRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IslemTipi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIslemTipi()
    {
        return isset($this->IslemTipi) ? $this->IslemTipi : null;
    }
    /**
     * Set IslemTipi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\WebhookIslem::valueIsValid()
     * @uses \EnumType\WebhookIslem::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $islemTipi
     * @return \StructType\SelectWebhookRequest
     */
    public function setIslemTipi($islemTipi = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WebhookIslem::valueIsValid($islemTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\WebhookIslem', is_array($islemTipi) ? implode(', ', $islemTipi) : var_export($islemTipi, true), implode(', ', \EnumType\WebhookIslem::getValidValues())), __LINE__);
        }
        if (is_null($islemTipi) || (is_array($islemTipi) && empty($islemTipi))) {
            unset($this->IslemTipi);
        } else {
            $this->IslemTipi = $islemTipi;
        }
        return $this;
    }
}
