<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectEntegrasyon StructType
 * @subpackage Structs
 */
class SelectEntegrasyon extends AbstractStructBase
{
    /**
     * The UyeKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UyeKodu;
    /**
     * The EntegrasyonKodu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntegrasyonKodu;
    /**
     * The KayitSayisi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KayitSayisi;
    /**
     * Constructor method for SelectEntegrasyon
     * @uses SelectEntegrasyon::setUyeKodu()
     * @uses SelectEntegrasyon::setEntegrasyonKodu()
     * @uses SelectEntegrasyon::setKayitSayisi()
     * @param string $uyeKodu
     * @param string $entegrasyonKodu
     * @param int $kayitSayisi
     */
    public function __construct($uyeKodu = null, $entegrasyonKodu = null, $kayitSayisi = null)
    {
        $this
            ->setUyeKodu($uyeKodu)
            ->setEntegrasyonKodu($entegrasyonKodu)
            ->setKayitSayisi($kayitSayisi);
    }
    /**
     * Get UyeKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUyeKodu()
    {
        return isset($this->UyeKodu) ? $this->UyeKodu : null;
    }
    /**
     * Set UyeKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uyeKodu
     * @return \StructType\SelectEntegrasyon
     */
    public function setUyeKodu($uyeKodu = null)
    {
        // validation for constraint: string
        if (!is_null($uyeKodu) && !is_string($uyeKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uyeKodu, true), gettype($uyeKodu)), __LINE__);
        }
        if (is_null($uyeKodu) || (is_array($uyeKodu) && empty($uyeKodu))) {
            unset($this->UyeKodu);
        } else {
            $this->UyeKodu = $uyeKodu;
        }
        return $this;
    }
    /**
     * Get EntegrasyonKodu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntegrasyonKodu()
    {
        return isset($this->EntegrasyonKodu) ? $this->EntegrasyonKodu : null;
    }
    /**
     * Set EntegrasyonKodu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entegrasyonKodu
     * @return \StructType\SelectEntegrasyon
     */
    public function setEntegrasyonKodu($entegrasyonKodu = null)
    {
        // validation for constraint: string
        if (!is_null($entegrasyonKodu) && !is_string($entegrasyonKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entegrasyonKodu, true), gettype($entegrasyonKodu)), __LINE__);
        }
        if (is_null($entegrasyonKodu) || (is_array($entegrasyonKodu) && empty($entegrasyonKodu))) {
            unset($this->EntegrasyonKodu);
        } else {
            $this->EntegrasyonKodu = $entegrasyonKodu;
        }
        return $this;
    }
    /**
     * Get KayitSayisi value
     * @return int|null
     */
    public function getKayitSayisi()
    {
        return $this->KayitSayisi;
    }
    /**
     * Set KayitSayisi value
     * @param int $kayitSayisi
     * @return \StructType\SelectEntegrasyon
     */
    public function setKayitSayisi($kayitSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kayitSayisi) && !(is_int($kayitSayisi) || ctype_digit($kayitSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kayitSayisi, true), gettype($kayitSayisi)), __LINE__);
        }
        $this->KayitSayisi = $kayitSayisi;
        return $this;
    }
}
